/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import static java.util.Objects.requireNonNull;
import static org.apache.commons.lang3.ObjectUtils.defaultIfNull;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Field;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.valueprovider.ValueProviderBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.AuxiliarParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class AuxiliarParameterBuilder {

  private final String name;
  private String displayName;
  private String muleAlias;
  private ParameterDataType dataType;
  private final TypeDefinitionBuilder typeDefinitionBuilder = new TypeDefinitionBuilder();
  private String description;
  private Boolean required;
  private final ValueProviderBuilder valueProviderExpressionBuilder = new ValueProviderBuilder();
  private String muleMetadataKeyId;
  private String muleTypeResolver;
  private Boolean muleContent;
  private final List<FieldBuilder> fieldBuilders = new ArrayList<>();

  public AuxiliarParameterBuilder(String name) {
    requireNonNull(name);
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public String geMuleAlias() {
    return muleAlias;
  }

  public ValueProviderBuilder getValueProviderExpressionBuilder() {
    return valueProviderExpressionBuilder;
  }

  public AuxiliarParameterBuilder displayName(String displayName) {
    this.displayName = defaultIfNull(displayName, this.displayName);
    return this;
  }

  public AuxiliarParameterBuilder muleAlias(String muleAlias) {
    this.muleAlias = defaultIfNull(muleAlias, this.muleAlias);
    return this;
  }

  public AuxiliarParameterBuilder dataType(ParameterDataType dataType) {
    this.dataType = defaultIfNull(dataType, this.dataType);
    return this;
  }

  public AuxiliarParameterBuilder description(String description) {
    this.description = defaultIfNull(description, this.description);
    return this;
  }

  public AuxiliarParameterBuilder required(Boolean required) {
    this.required = defaultIfNull(required, this.required);
    return this;
  }

  public AuxiliarParameterBuilder muleMetadataKeyId(String muleMetadataKeyId) {
    this.muleMetadataKeyId = defaultIfNull(muleMetadataKeyId, this.muleMetadataKeyId);
    return this;
  }

  public AuxiliarParameterBuilder muleTypeResolver(String muleTypeResolver) {
    this.muleTypeResolver = defaultIfNull(muleTypeResolver, this.muleTypeResolver);
    return this;
  }

  public AuxiliarParameterBuilder muleContent(Boolean muleContent) {
    this.muleContent = muleContent;
    return this;
  }

  public Boolean getMuleContent() {
    return muleContent;
  }

  public TypeDefinitionBuilder getTypeDefinitionBuilder() {
    return this.typeDefinitionBuilder;
  }


  public List<FieldBuilder> getFieldBuilders() {
    return fieldBuilders;
  }

  private List<Field> buildFields() {
    return fieldBuilders.stream().map(FieldBuilder::buildField).collect(Collectors.toList());
  }

  public AuxiliarParameter build(TypeSchemaPool typeSchemaPool) {
    TypeDefinition typeDefinition = null;
    if (dataType == null && muleTypeResolver == null) {
      typeDefinition = getTypeDefinitionBuilder().build(typeSchemaPool, null);
    }
    final AuxiliarParameter auxiliarParameter =
        new AuxiliarParameter(name, displayName, dataType, typeDefinition, muleAlias, description, required,
                              valueProviderExpressionBuilder.build(), muleMetadataKeyId, muleTypeResolver, muleContent,
                              buildFields(), null);
    return auxiliarParameter;
  }
}
