/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import static org.apache.commons.lang3.ObjectUtils.defaultIfNull;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Body;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Field;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.metadata.OverrideResolverBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw.BodyIdentifierExpressionHandler;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class BodyBuilder {

  private String bodyIdentifier;
  private final List<FieldBuilder> fieldBuilders = new ArrayList<>();

  private final OverrideResolverBuilder overrideResolverBuilder = new OverrideResolverBuilder();

  public BodyBuilder() {}

  public Body buildBody(BodyIdentifierExpressionHandler bodyIdentifierExpressionHandler,
                        String operationId, String method, String path) {
    List<Field> fields = fieldBuilders.stream().map(fieldBuilder -> fieldBuilder.buildField())
        .collect(Collectors.toList());
    return new Body(buildBodyIdentifier(bodyIdentifierExpressionHandler, operationId, method, path), fields,
                    overrideResolverBuilder.build());
  }

  private String buildBodyIdentifier(BodyIdentifierExpressionHandler bodyIdentifierExpressionHandler,
                                     String operationId, String method, String path) {
    String result = bodyIdentifier;
    if (bodyIdentifier == null) {
      result = bodyIdentifierExpressionHandler.evaluate(operationId, method, path, null);
    }
    return result;
  }

  public BodyBuilder bodyIdentifier(String bodyIdentifier) {
    this.bodyIdentifier = defaultIfNull(bodyIdentifier, this.bodyIdentifier);
    return this;
  }

  public String getBodyIdentifier() {
    return bodyIdentifier;
  }

  public List<FieldBuilder> getFieldBuilders() {
    return fieldBuilders;
  }

  public OverrideResolverBuilder getHttpOverrideResolverBuilder() {
    return overrideResolverBuilder;
  }

  // todo it seems we are missing an addField()
}
