/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.sampledata;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.sampledata.SampleDataBuilder.SampleDataType.INLINE;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.sampledata.SampleDataBuilder.SampleDataType.REFERENCE;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.ResolverDeclarationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.ResolverReferenceBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.operation.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;

public class SampleDataBuilder {

  protected enum SampleDataType {
    INLINE, REFERENCE;
  }

  private SampleDataType type;
  private SampleDataDefinitionBuilder definitionBuilder;
  private SampleDataReferenceBuilder referenceBuilder;

  public SampleDataBuilder() {

  }

  public SampleDataBuilder(SampleDataBuilder sampleDataBuilder) {
    this.type = sampleDataBuilder.type;
    this.definitionBuilder = sampleDataBuilder.definitionBuilder;
    this.referenceBuilder = sampleDataBuilder.referenceBuilder;
  }

  public SampleDataDefinitionBuilder inline() {
    this.type = INLINE;
    this.definitionBuilder = new SampleDataDefinitionBuilder();
    return definitionBuilder;
  }

  public SampleDataReferenceBuilder reference(String declarationName) {
    this.type = REFERENCE;

    this.referenceBuilder =
        new SampleDataReferenceBuilder(new SampleDataDeclarationBuilder(declarationName, new SampleDataDefinitionBuilder()));

    return referenceBuilder;
  }

  public ResolverExpression<SampleDataDefinition> build(ConnectorOperation operation) {
    return buildInternal(operation);
  }

  public ResolverExpression<SampleDataDefinition> build(Trigger trigger) {
    return buildInternal(trigger);
  }

  private ResolverExpression<SampleDataDefinition> buildInternal(Object parentElement) {
    if (type == null) {
      return null;
    }

    if (type.equals(INLINE)) {
      return definitionBuilder.build();
    }

    if (type.equals(REFERENCE)) {
      return referenceBuilder.build();
    }

    throw new IllegalArgumentException("Builder type not supported. This is a bug.");
  }


  public static class SampleDataDeclarationBuilder
      extends ResolverDeclarationBuilder<SampleDataDefinitionBuilder, SampleDataDefinition> {

    protected SampleDataDeclarationBuilder(String name, SampleDataDefinitionBuilder resolverDefinitionBuilder) {
      super(name, resolverDefinitionBuilder);
    }
  }

  public static class SampleDataReferenceBuilder
      extends ResolverReferenceBuilder<SampleDataDeclarationBuilder, SampleDataDefinitionBuilder, SampleDataDefinition> {

    protected SampleDataReferenceBuilder(SampleDataDeclarationBuilder declarationBuilder) {
      super(declarationBuilder);
    }
  }
}
