/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api.ApiTypeLoader.loadTypeDefinition;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType.valueOf;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.SecuritySchemeBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;

import java.util.List;

public class ApiParameterLoader {

  static SecuritySchemeBuilder loadSecuritySchemeParameters(List<APIParameterModel> apiParameters,
                                                            ParameterType parameterType,
                                                            SecuritySchemeBuilder securitySchemeBuilder) {
    for (APIParameterModel apiParameter : apiParameters) {
      loadParameter(apiParameter,
                    securitySchemeBuilder.getParameterBuilder(parameterType, apiParameter.getExternalName()));
    }

    return securitySchemeBuilder;
  }

  static OperationBuilder loadOperationParameters(List<APIParameterModel> apiParameters,
                                                  OperationBuilder operationBuilder) {
    for (APIParameterModel apiParameter : apiParameters) {
      ParameterBuilder connectorParameterBuilder =
          operationBuilder.getParameterBuilder(valueOf(apiParameter.getParameterType().name()),
                                               apiParameter.getExternalName());

      loadParameter(apiParameter, connectorParameterBuilder);
    }

    return operationBuilder;
  }

  static ParameterBuilder loadParameter(APIParameterModel apiParameter,
                                        ParameterBuilder parameterBuilder) {
    parameterBuilder
        .displayName(apiParameter.getDisplayName())
        .description(apiParameter.getDescription())
        .required(apiParameter.isRequired())
        .defaultValue(apiParameter.getDefaultValue())
        .password(apiParameter.isPassword());

    loadTypeDefinition(apiParameter.getTypeModel(), parameterBuilder.getTypeDefinitionBuilder());

    return parameterBuilder;
  }
}
