/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorTestConnectionLoader.loadTestConnection;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorTypeLoader.loadDataType;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType.HEADER;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType.QUERY;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.SecuritySchemeBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SecuritySchemeDescriptor;

import java.util.List;

public class DescriptorSecuritySchemeLoader {

  static ConnectorModelBuilder loadSecuritySchemes(ConnectorDescriptor connectorDescriptor,
                                                   ConnectorModelBuilder connectorModelBuilder) {
    for (SecuritySchemeDescriptor securityDescriptor : connectorDescriptor.getSecurity()) {
      loadSecurityScheme(securityDescriptor,
                         connectorModelBuilder.getSecuritySchemeBuilder(securityDescriptor.getName(), null));
    }

    return connectorModelBuilder;
  }

  private static SecuritySchemeBuilder loadSecurityScheme(SecuritySchemeDescriptor securityDescriptor,
                                                          SecuritySchemeBuilder securitySchemeBuilder) {

    securitySchemeBuilder
        .ignored(securityDescriptor.isIgnored())
        .testConnectionConfig(loadTestConnection(securityDescriptor.getTestConnection()));

    ExpressionDescriptor refreshTokenExpression = securityDescriptor.getRefreshTokenConditionExpressionDescriptor();
    if (refreshTokenExpression != null) {
      securitySchemeBuilder.refreshTokenConditionExpression(refreshTokenExpression.getExpression());
    }

    loadSecurityParameters(securityDescriptor.getQueryParameters(), QUERY, securitySchemeBuilder);
    loadSecurityParameters(securityDescriptor.getHeaders(), HEADER, securitySchemeBuilder);

    return securitySchemeBuilder;
  }

  private static SecuritySchemeBuilder loadSecurityParameters(List<ParameterDescriptor> parameters,
                                                              ParameterType parameterType,
                                                              SecuritySchemeBuilder securitySchemeBuilder) {
    if (parameters == null) {
      return null;
    }

    for (ParameterDescriptor parameterDescriptor : parameters) {
      loadSecurityParameter(parameterDescriptor,
                            securitySchemeBuilder.getParameterBuilder(parameterType, parameterDescriptor.getParamName()));
    }

    return securitySchemeBuilder;
  }

  private static ParameterBuilder loadSecurityParameter(ParameterDescriptor parameterDescriptor,
                                                        ParameterBuilder parameterBuilder) {

    parameterBuilder
        .displayName(parameterDescriptor.getDisplayName())
        .description(parameterDescriptor.getDescription())
        .defaultValue(parameterDescriptor.getDefaultValue())
        .required(parameterDescriptor.getRequired())
        .ignored(parameterDescriptor.isIgnored());

    loadDataType(parameterDescriptor, parameterBuilder.getTypeDefinitionBuilder());

    return parameterBuilder;
  }
}
