/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination;

import static org.apache.commons.lang3.StringUtils.isBlank;

public enum PaginationType {

  OFFSET("offset"), PAGE_NUMBER("pageNumber"), MARKER("marker"), HYPERMEDIA("hypermedia");

  private final String name;

  PaginationType(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public static PaginationType forName(String name) {
    if (isBlank(name)) {
      return null;
    }

    if (name.equalsIgnoreCase(OFFSET.name)) {
      return OFFSET;
    } else if (name.equalsIgnoreCase(PAGE_NUMBER.name)) {
      return PAGE_NUMBER;
    } else if (name.equalsIgnoreCase(MARKER.name)) {
      return MARKER;
    } else if (name.equalsIgnoreCase(HYPERMEDIA.name)) {
      return HYPERMEDIA;
    }

    throw new IllegalArgumentException("Pagination not supported: " + name);
  }
}
