/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType.TRIGGER;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.NamingUtil.buildParameterInternalName;
import static java.util.Collections.emptyList;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;

public class TriggerParameter {

  private final String externalName;
  private final String internalName;
  private final String displayName;
  private final ParameterDataType dataType;
  private final String description;
  private final Boolean required;

  public TriggerParameter(String externalName, String displayName, ParameterDataType dataType,
                          String description, Boolean required) {
    this.externalName = externalName;
    this.internalName =
        buildParameterInternalName(externalName, emptyList(), TRIGGER);

    this.dataType = dataType;
    this.displayName = displayName;
    this.description = description;
    this.required = required;
  }

  public String getExternalName() {
    return externalName;
  }

  public String getInternalName() {
    return internalName;
  }

  public String getDisplayName() {
    return displayName;
  }

  public ParameterDataType getType() {
    return dataType;
  }

  public String getDescription() {
    return description;
  }

  public Boolean isRequired() {
    return required;
  }
}
