/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorCategory;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.Protocol;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.uri.BaseUri;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.util.List;

public class ConnectorModel {
    private final String connectorName;
    private final String connectorXmlName;
    private final List<Protocol> protocols;
    private final List<Pagination> paginations;
    private final String description;
    private final BaseUri baseUri;
    private final ConnectorCategory category;
    private final List<ConnectorOperation> operations;
    private final String mvnGroupId;
    private final String mvnArtifactId;
    private final String mvnVersion;
    private final String basePackage;
    private final String extensionXml;
    private final Boolean skipOutputTypeValidation;
    private final List<Trigger> triggers;

    public ConnectorModel(String connectorName, String description, String mvnGroupId, String mvnArtifactId, String mvnVersion, String basePackage, ConnectorCategory category, BaseUri baseUri, List<Protocol> protocols, List<ConnectorOperation> operations, List<Pagination> paginations, String extensionXml, Boolean skipOutputTypeValidation, List<Trigger> triggers) {
        this.connectorName = connectorName;
        this.connectorXmlName = XmlUtils.getXmlName((String)connectorName);
        this.protocols = protocols;
        this.description = description;
        this.mvnGroupId = mvnGroupId;
        this.mvnArtifactId = mvnArtifactId;
        this.mvnVersion = mvnVersion;
        this.basePackage = basePackage;
        this.category = category;
        this.baseUri = baseUri;
        this.operations = operations;
        this.extensionXml = extensionXml;
        this.skipOutputTypeValidation = skipOutputTypeValidation;
        this.paginations = paginations;
        this.triggers = triggers;
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public List<ConnectorOperation> getOperations() {
        return this.operations;
    }

    public String getMvnGroupId() {
        return this.mvnGroupId;
    }

    public String getMvnArtifactId() {
        return this.mvnArtifactId;
    }

    public String getMvnVersion() {
        return this.mvnVersion;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public ConnectorCategory getCategory() {
        return this.category;
    }

    public BaseUri getBaseUri() {
        return this.baseUri;
    }

    public String getConnectorXmlName() {
        return this.connectorXmlName;
    }

    public String getApiDescription() {
        return this.description;
    }

    public List<Pagination> getPaginations() {
        return this.paginations;
    }

    public Pagination getPagination(String pagingName) {
        return this.paginations.stream().filter(x -> x.getName().equals(pagingName)).findFirst().orElse(null);
    }

    public boolean supportsHTTP() {
        return this.protocols.contains((Object)Protocol.HTTP);
    }

    public boolean supportsHTTPS() {
        return this.protocols.contains((Object)Protocol.HTTPS);
    }

    public String getExtensionXml() {
        return this.extensionXml;
    }

    public Boolean getSkipOutputTypeValidation() {
        return this.skipOutputTypeValidation;
    }

    public List<Trigger> getTriggers() {
        return this.triggers;
    }
}

