/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.SecuritySchemeBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api.ApiTypeLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIParameterModel;
import java.util.List;

public class ApiParameterLoader {
    static SecuritySchemeBuilder loadSecuritySchemeParameters(List<APIParameterModel> apiParameters, ParameterType parameterType, SecuritySchemeBuilder securitySchemeBuilder) {
        for (APIParameterModel apiParameter : apiParameters) {
            ApiParameterLoader.loadParameter(apiParameter, securitySchemeBuilder.getParameterBuilder(parameterType, apiParameter.getExternalName()));
        }
        return securitySchemeBuilder;
    }

    static OperationBuilder loadOperationParameters(List<APIParameterModel> apiParameters, OperationBuilder operationBuilder) {
        for (APIParameterModel apiParameter : apiParameters) {
            ParameterBuilder connectorParameterBuilder = operationBuilder.getParameterBuilder(ParameterType.valueOf(apiParameter.getParameterType().name()), apiParameter.getExternalName());
            ApiParameterLoader.loadParameter(apiParameter, connectorParameterBuilder);
        }
        return operationBuilder;
    }

    static ParameterBuilder loadParameter(APIParameterModel apiParameter, ParameterBuilder parameterBuilder) {
        parameterBuilder.displayName(apiParameter.getDisplayName()).description(apiParameter.getDescription()).required(apiParameter.isRequired()).defaultValue(apiParameter.getDefaultValue()).password(apiParameter.isPassword());
        ApiTypeLoader.loadTypeDefinition(apiParameter.getTypeModel(), parameterBuilder.getTypeDefinitionBuilder());
        return parameterBuilder;
    }
}

