/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.isXmlSchema;
import static org.apache.commons.lang.StringUtils.isNotBlank;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.JsonTypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.TypeSchema;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema.XmlTypeSchema;

public class TypeSchemaBuilder {

  private final TypeSchemaPool typeSchemaPool;

  public TypeSchemaBuilder(TypeSchemaPool typeSchemaPool) {
    this.typeSchemaPool = typeSchemaPool;
  }

  public TypeSchema buildTypeSchema(String rawSchema, String elementName, String path) {
    if (isXmlSchema(rawSchema)) {
      return getUniqueTypeSchema(new XmlTypeSchema(rawSchema, elementName, path));
    } else {
      return getUniqueTypeSchema(new JsonTypeSchema(rawSchema));
    }
  }

  private TypeSchema getUniqueTypeSchema(TypeSchema typeSchema) {
    if (typeSchema != null && isNotBlank(typeSchema.getRawSchema())) {
      return typeSchemaPool.getUniqueTypeSchema(typeSchema);
    }
    return typeSchema;
  }
}
