/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.sampledata;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.ResolverDeclarationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.ResolverReferenceBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.sampledata.SampleDataDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import java.util.Objects;

public class SampleDataBuilder {
    private SampleDataType type;
    private SampleDataDefinitionBuilder definitionBuilder;
    private SampleDataReferenceBuilder referenceBuilder;

    public SampleDataDefinitionBuilder inline() {
        this.type = SampleDataType.INLINE;
        this.definitionBuilder = new SampleDataDefinitionBuilder();
        return this.definitionBuilder;
    }

    public SampleDataReferenceBuilder reference(String declarationName) {
        this.type = SampleDataType.REFERENCE;
        this.referenceBuilder = new SampleDataReferenceBuilder(new SampleDataDeclarationBuilder(declarationName, new SampleDataDefinitionBuilder()));
        return this.referenceBuilder;
    }

    public void sameOperation() {
        this.type = SampleDataType.SAME_OPERATION;
    }

    public ResolverExpression<SampleDataDefinition> build(ConnectorOperation operation) {
        return this.buildInternal(operation);
    }

    public ResolverExpression<SampleDataDefinition> build(Trigger trigger) {
        return this.buildInternal(trigger);
    }

    private ResolverExpression<SampleDataDefinition> buildInternal(Object parentElement) {
        if (this.type == null) {
            return null;
        }
        if (this.type.equals((Object)SampleDataType.INLINE)) {
            return this.definitionBuilder.build();
        }
        if (this.type.equals((Object)SampleDataType.SAME_OPERATION)) {
            Objects.requireNonNull(parentElement);
            if (parentElement instanceof ConnectorOperation) {
                return new SampleDataDefinitionBuilder().buildSameOperation((ConnectorOperation)parentElement);
            }
            if (parentElement instanceof Trigger) {
                return new SampleDataDefinitionBuilder().buildSameOperation((Trigger)parentElement);
            }
            throw new IllegalArgumentException("parentElement not supported. This is a bug.");
        }
        if (this.type.equals((Object)SampleDataType.REFERENCE)) {
            return this.referenceBuilder.build();
        }
        throw new IllegalArgumentException("Builder type not supported. This is a bug.");
    }

    public static class SampleDataReferenceBuilder
    extends ResolverReferenceBuilder<SampleDataDeclarationBuilder, SampleDataDefinitionBuilder, SampleDataDefinition> {
        protected SampleDataReferenceBuilder(SampleDataDeclarationBuilder declarationBuilder) {
            super(declarationBuilder);
        }
    }

    public static class SampleDataDeclarationBuilder
    extends ResolverDeclarationBuilder<SampleDataDefinitionBuilder, SampleDataDefinition> {
        protected SampleDataDeclarationBuilder(String name, SampleDataDefinitionBuilder resolverDefinitionBuilder) {
            super(name, resolverDefinitionBuilder);
        }
    }

    protected static enum SampleDataType {
        INLINE,
        REFERENCE,
        SAME_OPERATION;

    }
}

