/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.weave.v2.model.ServiceManager;
import org.mule.weave.v2.parser.phase.CompilationException;
import org.mule.weave.v2.runtime.DataWeaveResult;
import org.mule.weave.v2.runtime.DataWeaveScript;
import org.mule.weave.v2.runtime.DataWeaveScriptingEngine;
import org.mule.weave.v2.runtime.ScriptingBindings;

public class ExpressionHandlerUtils {
    private static final String APPLICATION_JAVA = "application/java";

    public static DataWeaveScript compileDataWeaveScript(String weaveScript, String[] implicitInputs) throws CompilationException {
        DataWeaveScriptingEngine scriptingEngine = new DataWeaveScriptingEngine();
        return scriptingEngine.compile(ExpressionHandlerUtils.curateScript(weaveScript), implicitInputs);
    }

    static DataWeaveScript compileDataWeaveScript(Class clazz, String weaveScriptFile, String[] implicitInputs) {
        DataWeaveScriptingEngine scriptingEngine = new DataWeaveScriptingEngine();
        URL resourceWeave = ExpressionHandlerUtils.getResourceWeave(clazz, weaveScriptFile);
        return scriptingEngine.compile(resourceWeave, implicitInputs);
    }

    private static URL getResourceWeave(Class clazz, String weaveScriptFile) {
        URL resource = clazz.getResource(weaveScriptFile);
        if (resource == null) {
            throw new RuntimeException(String.format("Could not find DWL file '%s' in the resources, this is a bug", weaveScriptFile));
        }
        return resource;
    }

    public static String evaluate(DataWeaveScript script, Map<String, String> map, String contextInvoker) {
        ScriptingBindings bindings = ExpressionHandlerUtils.getBindings(map);
        DataWeaveResult dataWeaveResult = script.write(bindings, ServiceManager.apply(), APPLICATION_JAVA);
        if (!(dataWeaveResult.getContent() instanceof String)) {
            throw new IllegalArgumentException(String.format("Expression for [%s] must be a literal value, bindings used [%s]", contextInvoker, map.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(", "))));
        }
        return dataWeaveResult.getContentAsString();
    }

    private static ScriptingBindings getBindings(Map<String, String> map) {
        ScriptingBindings scriptingBindings = new ScriptingBindings();
        map.forEach((k, v) -> scriptingBindings.addBinding(k, v, APPLICATION_JAVA, new HashMap()));
        return scriptingBindings;
    }

    private static String curateScript(String script) {
        String trimmedScript = script.trim();
        if (trimmedScript.startsWith("#[") && trimmedScript.endsWith("]")) {
            trimmedScript = trimmedScript.substring(2, trimmedScript.length() - 1);
        }
        return trimmedScript;
    }
}

