/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.SecuritySchemeBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorTestConnectionLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorTypeLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.SecuritySchemeDescriptor;
import java.util.List;

public class DescriptorSecuritySchemeLoader {
    static ConnectorModelBuilder loadSecuritySchemes(ConnectorDescriptor connectorDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        for (SecuritySchemeDescriptor securityDescriptor : connectorDescriptor.getSecurity()) {
            DescriptorSecuritySchemeLoader.loadSecurityScheme(securityDescriptor, connectorModelBuilder.getOrCreateSecuritySchemeBuilder(securityDescriptor.getName(), null));
        }
        return connectorModelBuilder;
    }

    private static void loadSecurityScheme(SecuritySchemeDescriptor securityDescriptor, SecuritySchemeBuilder securitySchemeBuilder) {
        securitySchemeBuilder.ignored(securityDescriptor.isIgnored()).testConnectionConfig(DescriptorTestConnectionLoader.loadTestConnection(securityDescriptor.getTestConnection()));
        ExpressionDescriptor refreshTokenExpression = securityDescriptor.getRefreshTokenConditionExpressionDescriptor();
        if (refreshTokenExpression != null) {
            securitySchemeBuilder.refreshTokenConditionExpression(refreshTokenExpression.getExpression());
        }
        DescriptorSecuritySchemeLoader.loadSecurityParameters(securityDescriptor.getQueryParameters(), ParameterType.QUERY, securitySchemeBuilder);
        DescriptorSecuritySchemeLoader.loadSecurityParameters(securityDescriptor.getHeaders(), ParameterType.HEADER, securitySchemeBuilder);
    }

    private static void loadSecurityParameters(List<ParameterDescriptor> parameters, ParameterType parameterType, SecuritySchemeBuilder securitySchemeBuilder) {
        if (parameters == null) {
            return;
        }
        for (ParameterDescriptor parameterDescriptor : parameters) {
            DescriptorSecuritySchemeLoader.loadSecurityParameter(parameterDescriptor, securitySchemeBuilder.getOrCreateParameterBuilder(parameterType, parameterDescriptor.getParamName()));
        }
    }

    private static void loadSecurityParameter(ParameterDescriptor parameterDescriptor, ParameterBuilder parameterBuilder) {
        parameterBuilder.displayName(parameterDescriptor.getDisplayName()).description(parameterDescriptor.getDescription()).defaultValue(parameterDescriptor.getDefaultValue()).required(parameterDescriptor.getRequired()).ignored(parameterDescriptor.isIgnored());
        DescriptorTypeLoader.loadDataType(parameterDescriptor, parameterBuilder.getTypeDefinitionBuilder());
    }
}

