/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorDataExpressionLoader.loadRequestDataExpression;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorResolverLoader.loadResolverArguments;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorResolverLoader.loadResolverParameters;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.valueprovider.ValueProviderBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverReferenceDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.valueprovider.ValueProviderDefinitionDescriptor;

public class DescriptorValueProviderLoader {

  static void loadValueProvider(
                                ResolverExpressionDescriptor<ValueProviderDefinitionDescriptor> valueProviderDescriptor,
                                ValueProviderBuilder valueProviderBuilder) {

    if (valueProviderDescriptor == null) {
      return;
    }

    if (valueProviderDescriptor instanceof ResolverDefinitionDescriptor) {
      loadValueProviderDefinition((ValueProviderDefinitionDescriptor) valueProviderDescriptor, valueProviderBuilder.inline());
    }

    else if (valueProviderDescriptor instanceof ResolverReferenceDescriptor) {
      ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor> valueProviderReferenceDescriptor =
          (ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor>) valueProviderDescriptor;

      loadValueProviderReference(valueProviderReferenceDescriptor,
                                 valueProviderBuilder.reference(valueProviderReferenceDescriptor.getDeclaration().getName()));
    }
  }

  private static void loadValueProviderDefinition(
                                                  ValueProviderDefinitionDescriptor valueProviderDefinitionDescriptor,
                                                  ValueProviderBuilder.ValueProviderDefinitionBuilder valueProviderDefinitionBuilder) {

    valueProviderDefinitionBuilder
        .itemExtractionExpression(valueProviderDefinitionDescriptor.getItemsExtractionExpression())
        .itemValueExpression(valueProviderDefinitionDescriptor.getItemValueExpression())
        .itemDisplayNameExpression(valueProviderDefinitionDescriptor.getItemDisplayNameExpression())
        .request(loadRequestDataExpression(valueProviderDefinitionDescriptor.getRequest()));
  }

  private static void loadValueProviderReference(
                                                 ResolverReferenceDescriptor<ValueProviderDefinitionDescriptor> valueProviderReferenceDescriptor,
                                                 ValueProviderBuilder.ValueProviderReferenceBuilder valueProviderReferenceBuilder) {

    ValueProviderBuilder.ValueProviderDeclarationBuilder declarationBuilder =
        valueProviderReferenceBuilder
            .arguments(loadResolverArguments(valueProviderReferenceDescriptor.getArguments()))
            .getDeclarationBuilder();

    ValueProviderBuilder.ValueProviderDefinitionBuilder definitionBuilder =
        declarationBuilder
            .parameters(loadResolverParameters(valueProviderReferenceDescriptor.getDeclaration().getParameters()))
            .getDefinitionBuilder();

    loadValueProviderDefinition(valueProviderReferenceDescriptor.getDeclaration().getDefinition(), definitionBuilder);
  }
}
