/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.Protocol;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api.ApiOperationLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.api.ApiSecuritySchemeLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.uri.BaseUri;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.model.APIModel;
import java.util.List;
import java.util.stream.Collectors;

public class ApiConnectorModelLoader {
    public static ConnectorModelBuilder load(APIModel apiModel, ConnectorModelBuilder connectorModelBuilder) {
        List<Protocol> supportedProtocols = apiModel.getProtocols().stream().map(Protocol::getFromString).collect(Collectors.toList());
        connectorModelBuilder.name(apiModel.getApiName()).description(apiModel.getDescription()).supportedProtocols(supportedProtocols);
        connectorModelBuilder.getBaseUriBuilder().setType(BaseUri.Type.PARAMETER).setApiVersion(apiModel.getApiVersion()).setUri(apiModel.getBaseUri());
        ApiSecuritySchemeLoader.loadSecuritySchemes(apiModel, connectorModelBuilder);
        ApiOperationLoader.loadOperations(apiModel, connectorModelBuilder);
        return connectorModelBuilder;
    }
}

