/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.uri;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.Protocol;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BaseUri {
    private static final String VERSION_URI_PARAM_REGEX = "\\{version\\}";
    private static final String PROTOCOL_SEPARATOR = "://";
    private String uri;
    private final Type type;
    private Map<String, String> uriMappings;

    public BaseUri(String uri, Type type, String apiVersion, List<Protocol> supportedProtocols) {
        this.type = type;
        this.uri = this.formatUri(uri, supportedProtocols, apiVersion);
    }

    public BaseUri(Map<String, String> baseUris, String defaultUriId, String apiVersion, List<Protocol> supportedProtocols) {
        this.type = Type.MULTIPLE;
        baseUris.forEach((key, value) -> baseUris.put((String)key, this.formatUri((String)value, supportedProtocols, apiVersion)));
        this.uriMappings = baseUris;
        this.uri = this.uriMappings.get(defaultUriId);
    }

    private String formatUri(String uri, List<Protocol> supportedProtocols, String apiVersion) {
        if (uri == null) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)apiVersion)) {
            uri = uri.replaceAll(VERSION_URI_PARAM_REGEX, apiVersion);
        }
        if (uri.endsWith("/")) {
            uri = uri.substring(0, uri.length() - 1);
        }
        if (uri.contains(PROTOCOL_SEPARATOR)) {
            return uri;
        }
        if (!supportedProtocols.isEmpty() && !supportedProtocols.contains((Object)Protocol.HTTPS)) {
            return (Object)((Object)Protocol.HTTP) + PROTOCOL_SEPARATOR + uri;
        }
        return (Object)((Object)Protocol.HTTPS) + PROTOCOL_SEPARATOR + uri;
    }

    public Type getType() {
        return this.type;
    }

    public String getUri() {
        return this.uri;
    }

    public Map<String, String> getUriMappings() {
        return this.uriMappings;
    }

    public String getMultipleBaseUriOrDefault(String uriId) {
        return this.uriMappings.getOrDefault(uriId, this.uri);
    }

    public boolean isMultipleBaseUri() {
        return this.type == Type.MULTIPLE;
    }

    public boolean isParameterizedBaseUri() {
        return this.type == Type.PARAMETER;
    }

    public static enum Type {
        FIXED("fixed", "Fixed base URI specified in the API Spec"),
        PARAMETER("parameter", "Parameter base URI, each instance/tenant gets its own"),
        MULTIPLE("multiple", "Multiple base URI, each operation defines its own base URI");

        private static final Map<String, Type> BY_TYPE;
        private final String name;
        private final String description;

        private Type(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public static Type valueOfName(String name) {
            return BY_TYPE.get(name.toLowerCase());
        }

        static {
            BY_TYPE = new HashMap<String, Type>();
            for (Type e : Type.values()) {
                BY_TYPE.put(e.getName(), e);
            }
        }
    }
}

