%dw 2.0
import * from dw::core::Arrays
import * from dw::core::Strings
fun httpMethodToText(aMethod: String) : String =
    upper(aMethod) match {
        case "GET" -> "Get"
        case "POST" -> "Create"
        case "PUT" -> "Update"
        case "PATCH" -> "Patch"
        case "DELETE" -> "Delete"
        case "HEAD" -> "Get head"
        case "OPTIONS" -> "Get options"
        else -> "UNKNOWN METHOD '" ++ aMethod ++ "'"
    }

fun uriTemplateToText(aPath: String) : String = do {
    var splittedPath = (aPath splitBy(/\/|\{/)  -- [""] )
    var parted =  splittedPath partition (item) -> item contains "}"
    var params = {
        varPaths: (parted.success map ((item, index) -> item replace  "}" with "")) joinBy " ",
        staticPaths: parted.failure joinBy " "
    }
    var prettyPath =
        params.staticPaths ++ (
            if(isEmpty(params.varPaths)) "" else (
                if(isEmpty(params.staticPaths)) "by " else " by "
            ) ++ params.varPaths
        )
   ---
   lower(removeSpecialChars(capitalize(prettyPath)))
}

fun removeSpecialChars(phrase: String) : String =
    phrase replace  /[^a-z0-9A-Z ]/ with " "
      replace "  " with " "

fun displayNameFromSummary(aSummary: String) : String = do {
   trim(aSummary)
}
fun displayNameFromOperationId(operationId: String) : String = do {
   trim(capitalize(operationId))
}
fun displayNameFromMethodAndPath(aMethod: String, aPath: String) : String = do {
   trim(httpMethodToText(aMethod) ++ " " ++ uriTemplateToText(aPath))
}
