/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import static java.util.stream.Collectors.toList;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.script.DwScriptDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.script.ScriptDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.expression.DataWeaveExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.common.ArgumentDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.dataexpressions.HttpRequestDataExpressionBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.dataexpressions.HttpRequestDataExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.dataexpressions.ScriptDataExpressionDescriptor;

import java.util.List;

public class DescriptorDataExpressionLoader {

  static HttpRequestDataExpression loadRequestDataExpression(HttpRequestDataExpressionDescriptor dataExpressionDescriptor) {
    if (dataExpressionDescriptor != null) {
      return new HttpRequestDataExpression(
                                           dataExpressionDescriptor.getPath(),
                                           HTTPMethod.fromString(dataExpressionDescriptor.getMethod().getName()),
                                           loadHttpRequestBindings(dataExpressionDescriptor.getBindings()));
    }
    return null;
  }

  private static HttpRequestBinding loadHttpRequestBindings(HttpRequestDataExpressionBindingDescriptor bindings) {
    if (bindings != null) {
      return new HttpRequestBinding(loadArguments(bindings.getUriParameters()),
                                    loadArguments(bindings.getQueryParameters()),
                                    loadArguments(bindings.getHeaders()));
    }
    return null;
  }

  private static List<Argument> loadArguments(List<ArgumentDescriptor> argumentDescriptors) {
    return argumentDescriptors.stream()
        .map(x -> new Argument(x.getName(), new DataWeaveExpression(x.getValue())))
        .collect(toList());
  }

  static ScriptDataExpression loadScriptDataExpression(ScriptDataExpressionDescriptor scriptDescriptor) {
    if (scriptDescriptor != null) {
      return new DwScriptDataExpression(scriptDescriptor.getExpression());
    }
    return null;
  }

}
