/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.Protocol;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.uri.BaseUri;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;

public class BaseUriBuilder {
    private String uri;
    private BaseUri.Type type;
    private String apiVersion;
    private String defaultUriId;
    private final Map<String, String> uriMappings = new HashMap<String, String>();

    public BaseUriBuilder setUri(String uri) {
        this.uri = (String)ObjectUtils.defaultIfNull((Object)uri, (Object)this.uri);
        return this;
    }

    public BaseUriBuilder setType(BaseUri.Type type) {
        Objects.requireNonNull(type);
        this.type = type;
        return this;
    }

    public BaseUriBuilder setApiVersion(String apiVersion) {
        this.apiVersion = (String)ObjectUtils.defaultIfNull((Object)apiVersion, (Object)this.apiVersion);
        return this;
    }

    public BaseUriBuilder addMultipleBaseUri(String uriId, String uri, boolean isDefaultUri) {
        Objects.requireNonNull(uriId);
        Objects.requireNonNull(uri);
        this.type = BaseUri.Type.MULTIPLE;
        if (isDefaultUri) {
            this.defaultUriId = uriId;
        }
        this.uriMappings.put(uriId, uri);
        return this;
    }

    BaseUri build(List<Protocol> supportedProtocols) {
        Objects.requireNonNull(this.type);
        if (this.type.equals((Object)BaseUri.Type.MULTIPLE)) {
            return new BaseUri(this.uriMappings, this.defaultUriId, this.apiVersion, supportedProtocols);
        }
        return new BaseUri(this.uri, this.type, this.apiVersion, supportedProtocols);
    }
}

