/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.ParserUtils;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public final class NamingUtil {
    private static final List<ParameterType> namespacedParameters = Arrays.asList(ParameterType.URI, ParameterType.HEADER, ParameterType.QUERY);
    private static final Pattern CHARACTER_SPLIT_PATTERN = Pattern.compile("([a-zA-Z0-9])([\\-_.]+)([a-zA-Z0-9]*)");

    private NamingUtil() {
    }

    public static boolean isFriendlyName(String name) {
        if (StringUtils.isBlank((String)name)) {
            return false;
        }
        if (name.contains(" ")) {
            return true;
        }
        return ParserUtils.splitCaps((String)name, (String)" ").equalsIgnoreCase(name) && !CHARACTER_SPLIT_PATTERN.matcher(name).find();
    }

    public static String makeNameFriendly(String name) {
        String friendlyName = name.trim();
        if (friendlyName.contains(" ")) {
            return friendlyName;
        }
        while (CHARACTER_SPLIT_PATTERN.matcher(friendlyName).find()) {
            friendlyName = CHARACTER_SPLIT_PATTERN.matcher(friendlyName).replaceAll("$1 $3");
        }
        if ((friendlyName = ParserUtils.splitCaps((String)friendlyName, (String)" ")).toUpperCase().equals(friendlyName)) {
            friendlyName = friendlyName.toLowerCase();
        }
        return org.apache.commons.lang3.StringUtils.capitalize((String)friendlyName);
    }

    public static String buildParameterInternalName(String externalName, List<String> collisionInternalNames, ParameterType parameterType) {
        String name = XmlUtils.getXmlName((String)externalName);
        if (namespacedParameters.contains((Object)parameterType)) {
            name = name + "-" + XmlUtils.getXmlName((String)parameterType.getName());
        }
        if (NamingUtil.nameCollides(collisionInternalNames, name)) {
            int parameterNumber = 2;
            String numberName = name + "-" + parameterNumber;
            while (NamingUtil.nameCollides(collisionInternalNames, numberName)) {
                numberName = name + "-" + ++parameterNumber;
            }
            name = numberName;
        }
        return name;
    }

    private static boolean nameCollides(List<String> collisionNames, String name) {
        return collisionNames.stream().anyMatch(x -> x.equalsIgnoreCase(name));
    }
}

