/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Body;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Field;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class BodyBuilder {

  private final List<FieldBuilder> fieldBuilders = new ArrayList<>();

  public BodyBuilder() {}

  public Body buildBody() {
    List<Field> fields = fieldBuilders.stream().map(fieldBuilder -> fieldBuilder.buildField())
        .collect(Collectors.toList());
    return new Body(fields);
  }

  public List<FieldBuilder> getFieldBuilders() {
    return fieldBuilders;
  }
}
