/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver;

import static java.util.Objects.requireNonNull;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverReference;

import java.util.List;

public abstract class ResolverReferenceBuilder<T extends ResolverDeclarationBuilder<U, V>, U extends ResolverDefinitionBuilder<V>, V extends ResolverDefinition<V>> {

  private final T declarationBuilder;
  private List<Argument> arguments;

  protected ResolverReferenceBuilder(T declarationBuilder) {
    this.declarationBuilder = declarationBuilder;
  }

  public T getDeclarationBuilder() {
    return declarationBuilder;
  }

  public ResolverReferenceBuilder<T, U, V> arguments(List<Argument> arguments) {
    this.arguments = arguments;
    return this;
  }

  public ResolverReference<V> build() {
    requireNonNull(declarationBuilder);
    return new ResolverReference<V>(declarationBuilder.build(), arguments);
  }
}
