/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorTypeLoader.loadMediaType;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.TestConnectionConfig;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.TestConnectionValidationConfig;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TestConnectionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TestConnectionResponseValidationDescriptor;

import java.util.ArrayList;
import java.util.List;

public class DescriptorTestConnectionLoader {

  static TestConnectionConfig loadTestConnection(TestConnectionDescriptor testConnectionDescriptor) {
    if (testConnectionDescriptor == null) {
      return null;
    }

    return new TestConnectionConfig(testConnectionDescriptor.getPath(),
                                    loadHttpMethod(testConnectionDescriptor),
                                    testConnectionDescriptor.getValidStatusCodes(),
                                    loadMediaType(testConnectionDescriptor.getMediaType()),
                                    buildResponseValidations(testConnectionDescriptor.getResponseValidation()));
  }

  private static HTTPMethod loadHttpMethod(TestConnectionDescriptor testConnectionDescriptor) {
    return (testConnectionDescriptor.getMethod() == null) ? HTTPMethod.GET
        : HTTPMethod.fromString(testConnectionDescriptor.getMethod());
  }

  private static List<TestConnectionValidationConfig> buildResponseValidations(
                                                                               List<TestConnectionResponseValidationDescriptor> responseValidations) {

    List<TestConnectionValidationConfig> responseValidationConfigs = new ArrayList<>();

    for (TestConnectionResponseValidationDescriptor responseValidation : responseValidations) {
      responseValidationConfigs.add(
                                    new TestConnectionValidationConfig(
                                                                       loadValidationExpression(responseValidation),
                                                                       loadErrorTemplateExpression(responseValidation)));
    }

    return responseValidationConfigs;
  }

  private static String loadErrorTemplateExpression(TestConnectionResponseValidationDescriptor responseValidation) {
    return responseValidation.getErrorTemplateExpression() != null
        ? responseValidation.getErrorTemplateExpression().getExpression()
        : null;
  }

  private static String loadValidationExpression(TestConnectionResponseValidationDescriptor responseValidation) {
    return responseValidation.getValidationExpression() != null ? responseValidation.getValidationExpression().getExpression()
        : null;
  }
}
