/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination;

import org.apache.commons.lang3.StringUtils;

public enum PaginationType {
    OFFSET("offset"),
    PAGE_NUMBER("pageNumber"),
    MARKER("marker"),
    HYPERMEDIA("hypermedia");

    private final String name;

    private PaginationType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static PaginationType forName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        if (name.equalsIgnoreCase(PaginationType.OFFSET.name)) {
            return OFFSET;
        }
        if (name.equalsIgnoreCase(PaginationType.PAGE_NUMBER.name)) {
            return PAGE_NUMBER;
        }
        if (name.equalsIgnoreCase(PaginationType.MARKER.name)) {
            return MARKER;
        }
        if (name.equalsIgnoreCase(PaginationType.HYPERMEDIA.name)) {
            return HYPERMEDIA;
        }
        throw new IllegalArgumentException("Pagination not supported: " + name);
    }
}

