/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.QueryParamArrayFormat;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Body;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.Pagination;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.ParameterBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.TriggerParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils;
import java.util.List;
import java.util.Optional;

public class ConnectorOperation {
    private final String operationIdentifier;
    private final String internalName;
    private final String displayName;
    private final String description;
    private final String alternativeBaseUri;
    private final String path;
    private final HTTPMethod httpMethod;
    private final Pagination pagination;
    private final List<Parameter> uriParameters;
    private final List<Parameter> queryParameters;
    private final List<Parameter> headers;
    private final Body body;
    private final List<TriggerParameter> parameters;
    private final List<ParameterBinding> requestBindings;
    private final List<ParameterBinding> responseBindings;
    private final TypeDefinition inputMetadata;
    private final TypeDefinition outputMetadata;
    private final Boolean skipOutputTypeValidation;
    private final Boolean voidOperation;
    private final QueryParamArrayFormat queryParamArrayFormat;
    private final boolean isAdapter;
    private final boolean isSidecar;
    private final boolean isIgnored;
    private final List<ConnectorSecurityScheme> securitySchemes;
    private ResolverExpression<SampleDataDefinition> sampleData;

    public ConnectorOperation(String operationIdentifier, String displayName, String description, String path, HTTPMethod httpMethod, List<Parameter> uriParameters, List<Parameter> queryParameters, List<Parameter> headers, List<TriggerParameter> parameters, List<ParameterBinding> requestBindings, List<ParameterBinding> responseBindings, Body body, TypeDefinition inputMetadata, TypeDefinition outputMetadata, List<ConnectorSecurityScheme> securitySchemes, String alternativeBaseUri, Pagination pagination, Boolean skipOutputTypeValidation, Boolean voidOperation, QueryParamArrayFormat queryParamArrayFormat, boolean isIgnored, boolean isAdapter, boolean isSidecar) {
        this.operationIdentifier = operationIdentifier;
        this.parameters = parameters;
        this.requestBindings = requestBindings;
        this.responseBindings = responseBindings;
        this.isAdapter = isAdapter;
        this.isSidecar = isSidecar;
        this.internalName = XmlUtils.getXmlName((String)this.operationIdentifier.replaceAll("/", "-"));
        this.displayName = displayName;
        this.description = description;
        this.path = path;
        this.httpMethod = httpMethod;
        this.uriParameters = uriParameters;
        this.queryParameters = queryParameters;
        this.headers = headers;
        this.body = body;
        this.inputMetadata = inputMetadata;
        this.outputMetadata = outputMetadata;
        this.securitySchemes = securitySchemes;
        this.alternativeBaseUri = alternativeBaseUri;
        this.pagination = pagination;
        this.skipOutputTypeValidation = skipOutputTypeValidation;
        this.voidOperation = voidOperation;
        this.queryParamArrayFormat = queryParamArrayFormat;
        this.isIgnored = isIgnored;
    }

    public String getOperationIdentifier() {
        return this.operationIdentifier;
    }

    public List<Parameter> getQueryParameters() {
        return this.queryParameters;
    }

    public List<Parameter> getUriParameters() {
        return this.uriParameters;
    }

    public List<Parameter> getHeaders() {
        return this.headers;
    }

    public Body getBody() {
        return this.body;
    }

    public HTTPMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getPath() {
        return this.path;
    }

    public String getDescription() {
        return this.description;
    }

    public TypeDefinition getInputMetadata() {
        return this.inputMetadata;
    }

    public TypeDefinition getOutputMetadata() {
        return this.outputMetadata;
    }

    public List<ConnectorSecurityScheme> getSecuritySchemes() {
        return this.securitySchemes;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getAlternativeBaseUri() {
        return this.alternativeBaseUri;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public boolean hasPagination() {
        return this.pagination != null;
    }

    public Boolean getSkipOutputTypeValidation() {
        return this.skipOutputTypeValidation;
    }

    public Boolean getVoidOperation() {
        return this.voidOperation;
    }

    public QueryParamArrayFormat getQueryParamArrayFormat() {
        return this.queryParamArrayFormat;
    }

    public boolean isIgnored() {
        return this.isIgnored;
    }

    public ResolverExpression<SampleDataDefinition> getSampleData() {
        return this.sampleData;
    }

    public void setSampleData(ResolverExpression<SampleDataDefinition> sampleData) {
        this.sampleData = sampleData;
    }

    public Optional<List<TriggerParameter>> getParameters() {
        return Optional.ofNullable(this.parameters);
    }

    public Optional<List<ParameterBinding>> getRequestBindings() {
        return Optional.ofNullable(this.requestBindings);
    }

    public Optional<List<ParameterBinding>> getResponseBindings() {
        return Optional.ofNullable(this.responseBindings);
    }

    public boolean isAdapter() {
        return this.isAdapter;
    }

    public boolean isSidecar() {
        return this.isSidecar;
    }
}

