/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.translators;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TriggerParameterBindingBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TriggerParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TypeDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DataTypeDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterBindingsDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.TriggerParameterDescriptor;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;

public class ConnectorOperationAdapterTranslator {
    private static final ConnectorOperationAdapterTranslator INSTANCE = new ConnectorOperationAdapterTranslator();

    public static void translateOperationAdapters(ConnectorDescriptor connectorDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        INSTANCE._translateOperationAdapters(connectorDescriptor, connectorModelBuilder);
    }

    private void _translateOperationAdapters(ConnectorDescriptor connectorDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        for (OperationAdapterDescriptor operationAdapterDescriptor : connectorDescriptor.getOperationAdapterDescriptors()) {
            this.buildOperationAdapter(operationAdapterDescriptor, connectorModelBuilder);
        }
    }

    private void buildOperationAdapter(OperationAdapterDescriptor operationAdapterDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        OperationBuilder baseOperationBuilder = this.resolveBaseOperationBuilder(operationAdapterDescriptor, connectorModelBuilder);
        OperationBuilder operationBuilder = connectorModelBuilder.addOperationBuilder(operationAdapterDescriptor.getOperationId(), baseOperationBuilder.getPath(), baseOperationBuilder.getMethod());
        this.buildOperationAdapter(operationBuilder, operationAdapterDescriptor, baseOperationBuilder);
    }

    private OperationBuilder resolveBaseOperationBuilder(OperationAdapterDescriptor operationAdapterDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        String baseOperationId = operationAdapterDescriptor.getBaseOperationId();
        OperationBuilder operationBuildersByOperationId = connectorModelBuilder.getOperationBuildersByOperationId(baseOperationId).orElseThrow(() -> new IllegalArgumentException(String.format("Base operation not found %s", baseOperationId)));
        if (!operationBuildersByOperationId.isAdapter()) {
            return operationBuildersByOperationId;
        }
        throw new IllegalArgumentException(String.format("Base operation %s is not an endpoint operation.", baseOperationId));
    }

    private void buildOperationAdapter(OperationBuilder operationBuilder, OperationAdapterDescriptor operationAdapterDescriptor, OperationBuilder prototypeOperation) {
        operationBuilder.apply(prototypeOperation);
        operationBuilder.ignored(false);
        Optional.ofNullable(operationAdapterDescriptor.getDisplayName()).ifPresent(operationBuilder::displayName);
        Optional.ofNullable(operationAdapterDescriptor.getDescription()).ifPresent(operationBuilder::description);
        List<TriggerParameterBindingBuilder> requestBindings = this.buildRequestBindings(operationAdapterDescriptor.getRequestBindings());
        operationBuilder.requestBindings(requestBindings);
        List<TriggerParameterBindingBuilder> responseBindings = this.buildResponseBindings(operationAdapterDescriptor.getResponseBindings());
        operationBuilder.responseBindings(responseBindings);
        operationBuilder.uriParameters(this.filterParametersAlreadyBound(operationBuilder.getUriParameters(), requestBindings));
        operationBuilder.queryParameters(this.filterParametersAlreadyBound(operationBuilder.getQueryParameters(), requestBindings));
        operationBuilder.headers(this.filterParametersAlreadyBound(operationBuilder.getHeaders(), requestBindings));
        List parameters = operationAdapterDescriptor.getParameters();
        operationBuilder.parameters(this.buildParameters(parameters));
        this.getBodyBinding(requestBindings).ifPresent(triggerParameterBindingBuilder -> operationBuilder.getInputMetadata().clear());
        this.getBodyBinding(responseBindings).ifPresent(triggerParameterBindingBuilder -> {
            TypeDefinitionBuilder typeDefinitionBuilder = triggerParameterBindingBuilder.getTypeDefinitionBuilder();
            MediaType mediaType = typeDefinitionBuilder.getMediaType();
            Supplier<String> rawSchemaSupplier = typeDefinitionBuilder.getRawSchemaSupplier();
            if (mediaType != null && rawSchemaSupplier != null) {
                operationBuilder.forceOutputTypeSchema(rawSchemaSupplier.get()).setDefaultOutputMediaType(mediaType);
            }
        });
        operationBuilder.adapter();
        if (Optional.ofNullable(operationAdapterDescriptor.getSidecarOperation()).orElse(false).booleanValue()) {
            operationBuilder.sidecar();
        }
    }

    private List<ParameterBuilder> filterParametersAlreadyBound(List<ParameterBuilder> parameters, List<TriggerParameterBindingBuilder> requestBindings) {
        if (requestBindings == null) {
            return parameters;
        }
        return parameters.stream().filter(parameter -> !this.isParameterAlreadyBound((ParameterBuilder)parameter, requestBindings)).collect(Collectors.toList());
    }

    private boolean isParameterAlreadyBound(ParameterBuilder parameter, List<TriggerParameterBindingBuilder> requestBindings) {
        if (parameter == null) {
            throw new IllegalArgumentException();
        }
        if (requestBindings == null) {
            return false;
        }
        return requestBindings.stream().anyMatch(parameterBinding -> this.isSameBinding(parameter, (TriggerParameterBindingBuilder)parameterBinding));
    }

    private Optional<TriggerParameterBindingBuilder> getBodyBinding(List<TriggerParameterBindingBuilder> requestBindings) {
        if (requestBindings == null) {
            return Optional.empty();
        }
        return requestBindings.stream().filter(this::isBodyBinding).findFirst();
    }

    private boolean isSameBinding(ParameterBuilder parameter, TriggerParameterBindingBuilder parameterBinding) {
        return parameter.getParameterType().equals((Object)parameterBinding.getParameterType()) && parameter.getExternalName().equals(parameterBinding.getName());
    }

    private boolean isBodyBinding(TriggerParameterBindingBuilder parameterBinding) {
        return parameterBinding.getParameterType().equals((Object)ParameterType.BODY);
    }

    private List<TriggerParameterBindingBuilder> buildResponseBindings(TriggerParameterBindingsDescriptor parameterBindings) {
        return this.buildRequestBindings(parameterBindings);
    }

    private List<TriggerParameterBindingBuilder> buildRequestBindings(TriggerParameterBindingsDescriptor parameterBindings) {
        String requestBodyExpression;
        if (parameterBindings == null) {
            return null;
        }
        LinkedList<TriggerParameterBindingBuilder> parameterBindingList = new LinkedList<TriggerParameterBindingBuilder>();
        if (parameterBindings.getUriParameters() != null) {
            for (TriggerParameterBindingDescriptor uriParam : parameterBindings.getUriParameters()) {
                parameterBindingList.add(this.buildParameterBinding(uriParam, ParameterType.URI));
            }
        }
        if (parameterBindings.getQueryParameters() != null) {
            for (TriggerParameterBindingDescriptor queryParam : parameterBindings.getQueryParameters()) {
                parameterBindingList.add(this.buildParameterBinding(queryParam, ParameterType.QUERY));
            }
        }
        if (parameterBindings.getHeaders() != null) {
            for (TriggerParameterBindingDescriptor header : parameterBindings.getHeaders()) {
                parameterBindingList.add(this.buildParameterBinding(header, ParameterType.HEADER));
            }
        }
        if (parameterBindings.getBodyBindings() != null) {
            for (TriggerParameterBindingDescriptor body : parameterBindings.getBodyBindings()) {
                parameterBindingList.add(this.buildParameterBinding(body, ParameterType.BODY));
            }
        }
        if ((requestBodyExpression = parameterBindings.getRequestBodyExpression()) != null) {
            parameterBindingList.add(this.buildBodyParameterBinding(requestBodyExpression));
        }
        return parameterBindingList;
    }

    private TriggerParameterBindingBuilder buildBodyParameterBinding(String value) {
        TriggerParameterBindingBuilder triggerParameterBindingBuilder = new TriggerParameterBindingBuilder(ParameterType.BODY.getName(), ParameterType.BODY);
        triggerParameterBindingBuilder.value(value);
        return triggerParameterBindingBuilder;
    }

    private TriggerParameterBindingBuilder buildParameterBinding(TriggerParameterBindingDescriptor descriptor, ParameterType parameterType) {
        TriggerParameterBindingBuilder triggerParameterBindingBuilder = new TriggerParameterBindingBuilder(descriptor.getName(), parameterType);
        triggerParameterBindingBuilder.value(descriptor.getValue());
        String schemaType = descriptor.getInputType();
        if (StringUtils.isNotBlank((CharSequence)schemaType)) {
            TypeDefinitionBuilder typeDefinitionBuilder = triggerParameterBindingBuilder.getTypeDefinitionBuilder();
            typeDefinitionBuilder.object().typeSchema(() -> ((TriggerParameterBindingDescriptor)descriptor).getInputType());
            typeDefinitionBuilder.mediaType(ConnectorOperationAdapterTranslator.loadMediaType(descriptor.getContentType()));
        }
        return triggerParameterBindingBuilder;
    }

    private List<TriggerParameterBuilder> buildParameters(List<TriggerParameterDescriptor> parameterDescriptors) {
        LinkedList<TriggerParameterBuilder> parameters = new LinkedList<TriggerParameterBuilder>();
        if (parameterDescriptors != null) {
            for (TriggerParameterDescriptor parameterDescriptor : parameterDescriptors) {
                parameters.add(this.buildParameter(parameterDescriptor));
            }
        }
        return parameters;
    }

    private TriggerParameterBuilder buildParameter(TriggerParameterDescriptor parameterDescriptor) {
        TriggerParameterBuilder triggerParameterBuilder = new TriggerParameterBuilder(parameterDescriptor.getName());
        triggerParameterBuilder.displayName(parameterDescriptor.getDisplayName()).description(parameterDescriptor.getDescription()).required(parameterDescriptor.isRequired());
        DataTypeDescriptor dataType = parameterDescriptor.getDataType();
        if (dataType != null) {
            ParameterDataType parameterDataType = ParameterDataType.forName(dataType.getName());
            triggerParameterBuilder.dataType(parameterDataType);
        } else {
            TypeDefinitionBuilder typeDefinitionBuilder = triggerParameterBuilder.getTypeDefinitionBuilder();
            if (StringUtils.isNotBlank((CharSequence)parameterDescriptor.getInputType())) {
                typeDefinitionBuilder.object().typeSchema(() -> ((TriggerParameterDescriptor)parameterDescriptor).getInputType());
            }
            typeDefinitionBuilder.mediaType(ConnectorOperationAdapterTranslator.loadMediaType(parameterDescriptor.getContentType()));
        }
        return triggerParameterBuilder;
    }

    private static MediaType loadMediaType(String contentType) {
        return StringUtils.isEmpty((CharSequence)contentType) ? null : MediaType.valueOf((String)contentType);
    }
}

