/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import static java.util.Objects.requireNonNull;
import static org.apache.commons.lang3.ObjectUtils.defaultIfNull;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.AuxiliarParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;

import java.util.List;

public class AuxiliarParameterBuilder {

  private final String name;
  private String displayName;
  private ParameterDataType dataType;
  private final TypeDefinitionBuilder typeDefinitionBuilder = new TypeDefinitionBuilder();
  private String description;
  private Boolean required;

  public AuxiliarParameterBuilder(String name) {
    requireNonNull(name);
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public AuxiliarParameterBuilder displayName(String displayName) {
    this.displayName = defaultIfNull(displayName, this.displayName);
    return this;
  }

  public AuxiliarParameterBuilder dataType(ParameterDataType dataType) {
    this.dataType = defaultIfNull(dataType, this.dataType);
    return this;
  }

  public AuxiliarParameterBuilder description(String description) {
    this.description = defaultIfNull(description, this.description);
    return this;
  }

  public AuxiliarParameterBuilder required(Boolean required) {
    this.required = defaultIfNull(required, this.required);
    return this;
  }

  public TypeDefinitionBuilder getTypeDefinitionBuilder() {
    return this.typeDefinitionBuilder;
  }

  public AuxiliarParameter build() {
    return new AuxiliarParameter(name, displayName, dataType, null, description, required);
  }

  public AuxiliarParameter build(TypeSchemaPool typeSchemaPool, List<String> collisionParameterNames) {
    TypeDefinition typeDefinition = null;
    if (dataType == null) {
      typeDefinition = getTypeDefinitionBuilder().build(typeSchemaPool, null);
    }
    final AuxiliarParameter auxiliarParameter =
        new AuxiliarParameter(name, displayName, dataType, typeDefinition, description, required);
    collisionParameterNames.add(auxiliarParameter.getInternalName());
    return auxiliarParameter;
  }
}
