/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType.STRING;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.HashCodeUtil.generateHashCode;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.NamingUtil.buildParameterInternalName;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;

import java.util.List;

public class Parameter extends BaseParameter {

  private final String defaultValue;
  private final boolean isPassword;
  private final ResolverExpression<ValueProviderDefinition> valueProvider;

  public Parameter(String displayName,
                   String externalName,
                   ParameterType parameterType,
                   TypeDefinition typeDefinition,
                   String description,
                   boolean required,
                   String defaultValue,
                   boolean password,
                   ResolverExpression<ValueProviderDefinition> valueProvider,
                   List<String> collisionInternalNames) {

    this(buildParameterInternalName(externalName, collisionInternalNames, parameterType),
         displayName,
         externalName,
         parameterType,
         typeDefinition,
         description,
         required,
         defaultValue,
         password,
         valueProvider);
  }

  protected Parameter(String internalName,
                      String displayName,
                      String externalName,
                      ParameterType parameterType,
                      TypeDefinition typeDefinition,
                      String description,
                      boolean required,
                      String defaultValue,
                      boolean password,
                      ResolverExpression<ValueProviderDefinition> valueProvider) {
    super(externalName, internalName, displayName, STRING, typeDefinition, description, required, parameterType);

    this.isPassword = password;
    this.defaultValue = defaultValue;
    this.valueProvider = valueProvider;
  }

  public String getDefaultValue() {
    return defaultValue;
  }

  public boolean isPassword() {
    return isPassword;
  }

  public ResolverExpression<ValueProviderDefinition> getValueProvider() {
    return valueProvider;
  }

  @Override
  public int hashCode() {
    return generateHashCode(internalName, displayName, description, required, defaultValue, typeDefinition,
                            isPassword);
  }

}
