/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.translators;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.AuxiliarParameterBindingBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.AuxiliarParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TypeDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterBindingDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterBindingsDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.AuxiliarParameterDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.DataTypeDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationAdapterDescriptor;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.StringUtils;

public class ConnectorOperationAdapterTranslator {
    private static final ConnectorOperationAdapterTranslator INSTANCE = new ConnectorOperationAdapterTranslator();

    public static void translateOperationAdapters(ConnectorDescriptor connectorDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        INSTANCE._translateOperationAdapters(connectorDescriptor, connectorModelBuilder);
    }

    private void _translateOperationAdapters(ConnectorDescriptor connectorDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        for (OperationAdapterDescriptor operationAdapterDescriptor : connectorDescriptor.getOperationAdapterDescriptors()) {
            this.buildOperationAdapter(operationAdapterDescriptor, connectorModelBuilder);
        }
    }

    private void buildOperationAdapter(OperationAdapterDescriptor operationAdapterDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        OperationBuilder baseOperationBuilder = this.resolveBaseOperationBuilder(operationAdapterDescriptor, connectorModelBuilder);
        OperationBuilder operationBuilder = connectorModelBuilder.addOperationBuilder(operationAdapterDescriptor.getOperationId(), baseOperationBuilder.getPath(), baseOperationBuilder.getMethod());
        this.buildOperationAdapter(operationBuilder, operationAdapterDescriptor, baseOperationBuilder);
    }

    private OperationBuilder resolveBaseOperationBuilder(OperationAdapterDescriptor operationAdapterDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        String baseOperationId = operationAdapterDescriptor.getBaseOperationId();
        OperationBuilder operationBuildersByOperationId = connectorModelBuilder.getOperationBuildersByOperationId(baseOperationId).orElseThrow(() -> new IllegalArgumentException(String.format("Base operation not found %s", baseOperationId)));
        if (!operationBuildersByOperationId.isAdapter()) {
            return operationBuildersByOperationId;
        }
        throw new IllegalArgumentException(String.format("Base operation %s is not an endpoint operation.", baseOperationId));
    }

    private void buildOperationAdapter(OperationBuilder operationBuilder, OperationAdapterDescriptor operationAdapterDescriptor, OperationBuilder prototypeOperation) {
        operationBuilder.apply(prototypeOperation);
        operationBuilder.ignored(false);
        Optional.ofNullable(operationAdapterDescriptor.getDisplayName()).ifPresent(operationBuilder::displayName);
        Optional.ofNullable(operationAdapterDescriptor.getDescription()).ifPresent(operationBuilder::description);
        List<AuxiliarParameterBindingBuilder> requestBindings = this.buildRequestBindings(operationAdapterDescriptor.getRequestBindings());
        operationBuilder.requestBindings(requestBindings);
        List<AuxiliarParameterBindingBuilder> responseBindings = this.buildResponseBindings(operationAdapterDescriptor.getResponseBindings());
        operationBuilder.responseBindings(responseBindings);
        operationBuilder.uriParameters(this.filterParametersAlreadyBound(operationBuilder.getUriParameters(), requestBindings));
        operationBuilder.queryParameters(this.filterParametersAlreadyBound(operationBuilder.getQueryParameters(), requestBindings));
        operationBuilder.headers(this.filterParametersAlreadyBound(operationBuilder.getHeaders(), requestBindings));
        List parameters = operationAdapterDescriptor.getParameters();
        operationBuilder.parameters(this.buildParameters(parameters));
        this.getBodyBinding(requestBindings).ifPresent(auxiliarParameterBindingBuilder -> operationBuilder.getInputMetadata().clear());
        this.getBodyBinding(responseBindings).ifPresent(auxiliarParameterBindingBuilder -> {
            TypeDefinitionBuilder typeDefinitionBuilder = auxiliarParameterBindingBuilder.getTypeDefinitionBuilder();
            MediaType mediaType = typeDefinitionBuilder.getMediaType();
            Supplier<String> rawSchemaSupplier = typeDefinitionBuilder.getRawSchemaSupplier();
            if (mediaType != null && rawSchemaSupplier != null) {
                operationBuilder.forceOutputTypeSchema(rawSchemaSupplier.get()).setDefaultOutputMediaType(mediaType);
            }
        });
        operationBuilder.adapter();
        if (Optional.ofNullable(operationAdapterDescriptor.getSidecarOperation()).orElse(false).booleanValue()) {
            operationBuilder.sidecar();
        }
    }

    private List<ParameterBuilder> filterParametersAlreadyBound(List<ParameterBuilder> parameters, List<AuxiliarParameterBindingBuilder> requestBindings) {
        if (requestBindings == null) {
            return parameters;
        }
        return parameters.stream().filter(parameter -> !this.isParameterAlreadyBound((ParameterBuilder)parameter, requestBindings)).collect(Collectors.toList());
    }

    private boolean isParameterAlreadyBound(ParameterBuilder parameter, List<AuxiliarParameterBindingBuilder> requestBindings) {
        if (parameter == null) {
            throw new IllegalArgumentException();
        }
        if (requestBindings == null) {
            return false;
        }
        return requestBindings.stream().anyMatch(parameterBinding -> this.isSameBinding(parameter, (AuxiliarParameterBindingBuilder)parameterBinding));
    }

    private Optional<AuxiliarParameterBindingBuilder> getBodyBinding(List<AuxiliarParameterBindingBuilder> requestBindings) {
        if (requestBindings == null) {
            return Optional.empty();
        }
        return requestBindings.stream().filter(this::isBodyBinding).findFirst();
    }

    private boolean isSameBinding(ParameterBuilder parameter, AuxiliarParameterBindingBuilder parameterBinding) {
        return parameter.getParameterType().equals((Object)parameterBinding.getParameterType()) && parameter.getExternalName().equals(parameterBinding.getName());
    }

    private boolean isBodyBinding(AuxiliarParameterBindingBuilder parameterBinding) {
        return parameterBinding.getParameterType().equals((Object)ParameterType.BODY);
    }

    private List<AuxiliarParameterBindingBuilder> buildResponseBindings(AuxiliarParameterBindingsDescriptor parameterBindings) {
        return this.buildRequestBindings(parameterBindings);
    }

    private List<AuxiliarParameterBindingBuilder> buildRequestBindings(AuxiliarParameterBindingsDescriptor parameterBindings) {
        String requestBodyExpression;
        if (parameterBindings == null) {
            return null;
        }
        LinkedList<AuxiliarParameterBindingBuilder> parameterBindingList = new LinkedList<AuxiliarParameterBindingBuilder>();
        if (parameterBindings.getUriParameters() != null) {
            for (AuxiliarParameterBindingDescriptor uriParam : parameterBindings.getUriParameters()) {
                parameterBindingList.add(this.buildParameterBinding(uriParam, ParameterType.URI));
            }
        }
        if (parameterBindings.getQueryParameters() != null) {
            for (AuxiliarParameterBindingDescriptor queryParam : parameterBindings.getQueryParameters()) {
                parameterBindingList.add(this.buildParameterBinding(queryParam, ParameterType.QUERY));
            }
        }
        if (parameterBindings.getHeaders() != null) {
            for (AuxiliarParameterBindingDescriptor header : parameterBindings.getHeaders()) {
                parameterBindingList.add(this.buildParameterBinding(header, ParameterType.HEADER));
            }
        }
        if (parameterBindings.getBodyBindings() != null) {
            for (AuxiliarParameterBindingDescriptor body : parameterBindings.getBodyBindings()) {
                parameterBindingList.add(this.buildParameterBinding(body, ParameterType.BODY));
            }
        }
        if ((requestBodyExpression = parameterBindings.getRequestBodyExpression()) != null) {
            parameterBindingList.add(this.buildBodyParameterBinding(requestBodyExpression));
        }
        return parameterBindingList;
    }

    private AuxiliarParameterBindingBuilder buildBodyParameterBinding(String value) {
        AuxiliarParameterBindingBuilder auxiliarParameterBindingBuilder = new AuxiliarParameterBindingBuilder(ParameterType.BODY.getName(), ParameterType.BODY);
        auxiliarParameterBindingBuilder.value(value);
        return auxiliarParameterBindingBuilder;
    }

    private AuxiliarParameterBindingBuilder buildParameterBinding(AuxiliarParameterBindingDescriptor descriptor, ParameterType parameterType) {
        AuxiliarParameterBindingBuilder auxiliarParameterBindingBuilder = new AuxiliarParameterBindingBuilder(descriptor.getName(), parameterType);
        auxiliarParameterBindingBuilder.value(descriptor.getValue());
        String schemaType = descriptor.getInputType();
        if (StringUtils.isNotBlank((CharSequence)schemaType)) {
            TypeDefinitionBuilder typeDefinitionBuilder = auxiliarParameterBindingBuilder.getTypeDefinitionBuilder();
            typeDefinitionBuilder.object().typeSchema(() -> ((AuxiliarParameterBindingDescriptor)descriptor).getInputType());
            typeDefinitionBuilder.mediaType(ConnectorOperationAdapterTranslator.loadMediaType(descriptor.getContentType()));
        }
        return auxiliarParameterBindingBuilder;
    }

    private List<AuxiliarParameterBuilder> buildParameters(List<AuxiliarParameterDescriptor> parameterDescriptors) {
        LinkedList<AuxiliarParameterBuilder> parameters = new LinkedList<AuxiliarParameterBuilder>();
        if (parameterDescriptors != null) {
            for (AuxiliarParameterDescriptor parameterDescriptor : parameterDescriptors) {
                parameters.add(this.buildParameter(parameterDescriptor));
            }
        }
        return parameters;
    }

    private AuxiliarParameterBuilder buildParameter(AuxiliarParameterDescriptor parameterDescriptor) {
        AuxiliarParameterBuilder auxiliarParameterBuilder = new AuxiliarParameterBuilder(parameterDescriptor.getName());
        auxiliarParameterBuilder.displayName(parameterDescriptor.getDisplayName()).description(parameterDescriptor.getDescription()).required(parameterDescriptor.isRequired());
        DataTypeDescriptor dataType = parameterDescriptor.getDataType();
        if (dataType != null) {
            ParameterDataType parameterDataType = ParameterDataType.forName(dataType.getName());
            auxiliarParameterBuilder.dataType(parameterDataType);
        } else {
            TypeDefinitionBuilder typeDefinitionBuilder = auxiliarParameterBuilder.getTypeDefinitionBuilder();
            if (StringUtils.isNotBlank((CharSequence)parameterDescriptor.getInputType())) {
                typeDefinitionBuilder.object().typeSchema(() -> ((AuxiliarParameterDescriptor)parameterDescriptor).getInputType());
            }
            typeDefinitionBuilder.mediaType(ConnectorOperationAdapterTranslator.loadMediaType(parameterDescriptor.getContentType()));
        }
        return auxiliarParameterBuilder;
    }

    private static MediaType loadMediaType(String contentType) {
        return StringUtils.isEmpty((CharSequence)contentType) ? null : MediaType.valueOf((String)contentType);
    }
}

