/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw;

import org.mule.weave.v2.parser.phase.CompilationException;
import org.mule.weave.v2.runtime.DataWeaveScript;

import java.util.HashMap;
import java.util.Map;

public class OperationDisplayNameExpressionHandler {

  public static final String[] IMPLICIT_INPUTS = {"operationId", "method", "path", "summary"};
  private static DataWeaveScript DEFAULT_SCRIPT =
      ExpressionHandlerUtils.compileDataWeaveScript(OperationDisplayNameExpressionHandler.class, "operationDisplayName.dwl",
                                                    IMPLICIT_INPUTS);;
  private final DataWeaveScript script;

  /**
   * An operation display name expression that will use the default dataweave script.
   */
  public OperationDisplayNameExpressionHandler() {
    this.script = DEFAULT_SCRIPT;
  }

  /**
   * An operation display name expression with a custom dataweave script.
   *
   * @param script parameterized by the user, which might have the extra '#['/']' we need to remove
   * @throws CompilationException if the user consumes bindings that are not present, see {@link #IMPLICIT_INPUTS}
   */
  public OperationDisplayNameExpressionHandler(String script) throws CompilationException {
    this.script = ExpressionHandlerUtils.compileDataWeaveScript(script, IMPLICIT_INPUTS);
  }

  public String evaluate(String operationId, String method, String path, String summary) {
    String contextInvoker = "operationDisplayName";
    Map<String, String> map = new HashMap<>();
    map.put("operationId", operationId);
    map.put("method", method);
    map.put("path", path);
    map.put("summary", summary);
    return ExpressionHandlerUtils.evaluate(script, map, contextInvoker);
  }
}
