/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.pagination.PaginationType.forName;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.PaginationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PaginationDeclarationDescriptor;

public class DescriptorPaginationLoader {

  static void loadPaginations(ConnectorDescriptor connectorDescriptor,
                              ConnectorModelBuilder connectorBuilder) {
    for (PaginationDeclarationDescriptor paginationDeclaration : connectorDescriptor.getPaginations()) {
      loadPagination(paginationDeclaration, connectorBuilder.getOrCreatePaginationBuilder(paginationDeclaration.getName()));
    }
  }

  private static void loadPagination(PaginationDeclarationDescriptor paginationDeclaration,
                                     PaginationBuilder paginationBuilder) {

    paginationBuilder
        .type(forName(paginationDeclaration.getType()))
        .paginationParameterName(paginationDeclaration.getPaginationParameterName())
        .initialPageNumber(paginationDeclaration.getInitialPageNumber())
        .initialOffset(paginationDeclaration.getInitialOffset());

    if (paginationDeclaration.getPagingResponseExpression() != null) {
      paginationBuilder.pagingResponseExpression(paginationDeclaration.getPagingResponseExpression().getExpression());
    }

    if (paginationDeclaration.getNextTokenExpression() != null) {
      paginationBuilder.nextTokenExpression(paginationDeclaration.getNextTokenExpression().getExpression());
    }

    if (paginationDeclaration.getNextUrlExpression() != null) {
      paginationBuilder.nextUrlExpression(paginationDeclaration.getNextUrlExpression().getExpression());
    }

    if (paginationDeclaration.getPageCountExpression() != null) {
      paginationBuilder.pageCountExpression(paginationDeclaration.getPageCountExpression().getExpression());
    }
  }
}
