/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorDataExpressionLoader.loadRequestDataExpression;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorDataExpressionLoader.loadScriptDataExpression;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorResolverLoader.loadResolverArguments;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorResolverLoader.loadResolverParameters;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.sampledata.SampleDataBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.sampledata.SampleDataDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverReferenceDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.sampledata.SampleDataDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.sampledata.SampleDataSameOperationDefinitionDescriptor;

public class DescriptorSampleDataLoader {

  public static void loadSampleData(ResolverExpressionDescriptor<SampleDataDefinitionDescriptor> sampleDataDescriptor,
                                    SampleDataBuilder sampleDataBuilder) {
    if (sampleDataDescriptor == null) {
      return;
    }

    if (sampleDataDescriptor instanceof ResolverDefinitionDescriptor) {
      if (sampleDataDescriptor instanceof SampleDataSameOperationDefinitionDescriptor) {
        sampleDataBuilder.sameOperation();
      } else {
        loadSampleDataDefinition((SampleDataDefinitionDescriptor) sampleDataDescriptor, sampleDataBuilder.inline());
      }
    }

    else if (sampleDataDescriptor instanceof ResolverReferenceDescriptor) {
      ResolverReferenceDescriptor<SampleDataDefinitionDescriptor> sampleDataReferenceDescriptor =
          (ResolverReferenceDescriptor<SampleDataDefinitionDescriptor>) sampleDataDescriptor;

      loadSampleDataReference(sampleDataReferenceDescriptor,
                              sampleDataBuilder.reference(sampleDataReferenceDescriptor.getDeclaration().getName()));
    }
  }

  private static void loadSampleDataReference(
                                              ResolverReferenceDescriptor<SampleDataDefinitionDescriptor> sampleDataReferenceDescriptor,
                                              SampleDataBuilder.SampleDataReferenceBuilder sampleDataReferenceBuilder) {

    SampleDataBuilder.SampleDataDeclarationBuilder declarationBuilder =
        sampleDataReferenceBuilder
            .arguments(loadResolverArguments(sampleDataReferenceDescriptor.getArguments()))
            .getDeclarationBuilder();

    SampleDataDefinitionBuilder definitionBuilder = declarationBuilder
        .parameters(loadResolverParameters(sampleDataReferenceDescriptor.getDeclaration().getParameters()))
        .getDefinitionBuilder();

    loadSampleDataDefinition(sampleDataReferenceDescriptor.getDeclaration().getDefinition(), definitionBuilder);
  }

  private static void loadSampleDataDefinition(SampleDataDefinitionDescriptor sampleDataDescriptor,
                                               SampleDataDefinitionBuilder sampleDataBuilder) {

    sampleDataBuilder
        .httpRequestDataExpression(loadRequestDataExpression(sampleDataDescriptor.getResult()))
        .scriptDataExpression(loadScriptDataExpression(sampleDataDescriptor.getTransform()));
  }

}
