/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.script.ScriptDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverDefinition;

public class SampleDataDefinition extends ResolverDefinition<SampleDataDefinition> {

  private final HttpRequestDataExpression result;
  private final ScriptDataExpression transformation;

  public SampleDataDefinition(HttpRequestDataExpression result) {
    this(result, null);
  }

  public SampleDataDefinition(HttpRequestDataExpression result, ScriptDataExpression transformation) {
    this.result = result;
    this.transformation = transformation;
  }

  public HttpRequestDataExpression getResult() {
    return result;
  }

  public ScriptDataExpression getTransformation() {
    return transformation;
  }
}
