/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.schema;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.HashCodeUtil;

import java.util.function.Supplier;

public abstract class TypeSchema {

  protected Supplier<String> rawSchemaSupplier;
  protected String rawSchema;

  public TypeSchema(Supplier<String> rawSchemaSupplier) {
    this.rawSchemaSupplier = rawSchemaSupplier;
  }

  public TypeSchema(String rawSchema) {
    this.rawSchema = rawSchema;
  }

  public String getRawSchema() {
    if (rawSchema == null) {
      rawSchema = rawSchemaSupplier.get();
    }

    return rawSchema;
  }

  @Override
  public int hashCode() {
    return HashCodeUtil.generateHashCode(rawSchema);
  }
}
