/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.NamingUtil.buildParameterInternalName;
import static java.util.Collections.emptyList;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;

public abstract class BaseParameter {

  protected final String externalName;
  protected final String internalName;
  protected final String displayName;
  protected final ParameterDataType dataType;
  protected TypeDefinition typeDefinition;
  protected final String description;
  protected final Boolean required;
  protected final ParameterType parameterType;

  public BaseParameter(String externalName, String displayName, ParameterDataType dataType, TypeDefinition typeDefinition,
                       String description, Boolean required, ParameterType parameterType) {
    this(externalName, buildParameterInternalName(externalName, emptyList(), parameterType), displayName, dataType,
         typeDefinition, description, required, parameterType);

  }

  public BaseParameter(String externalName, String internalName, String displayName, ParameterDataType dataType,
                       TypeDefinition typeDefinition,
                       String description, Boolean required, ParameterType parameterType) {
    this.externalName = externalName;
    this.internalName = internalName;
    this.dataType = dataType;
    this.displayName = displayName;
    this.typeDefinition = typeDefinition;
    this.description = description;
    this.required = required;
    this.parameterType = parameterType;
  }

  public String getExternalName() {
    return externalName;
  }

  public String getInternalName() {
    return internalName;
  }

  public String getDisplayName() {
    return displayName;
  }

  public ParameterDataType getType() {
    return dataType;
  }

  public TypeDefinition getTypeDefinition() {
    return typeDefinition;
  }

  public String getDescription() {
    return description;
  }

  public Boolean isRequired() {
    return required;
  }

  public ParameterType getParameterType() {
    return parameterType;
  }
}
