/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security;


import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.HTTPMethod;

import java.util.List;
import java.util.Set;

import javax.ws.rs.core.MediaType;

/**
 * The configuration for how a connection should assert that it's connection is valid.
 */
public class TestConnectionConfig {

  private final String path;
  private final HTTPMethod method;
  private final Set<String> validStatusCodes;
  private final MediaType mediaType;
  private final List<TestConnectionValidationConfig> validations;

  public TestConnectionConfig(String path, HTTPMethod method, Set<String> validStatusCodes, MediaType mediaType,
                              List<TestConnectionValidationConfig> validations) {
    this.path = path;
    this.method = method;
    this.validStatusCodes = validStatusCodes;
    this.mediaType = mediaType;
    this.validations = validations;
  }

  public String getPath() {
    return path;
  }

  public HTTPMethod getMethod() {
    return method;
  }

  public Set<String> getValidStatusCodes() {
    return validStatusCodes;
  }

  public MediaType getMediaType() {
    return mediaType;
  }

  public List<TestConnectionValidationConfig> getValidations() {
    return validations;
  }
}
