/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dw;

import org.mule.weave.v2.parser.phase.CompilationException;
import org.mule.weave.v2.runtime.DataWeaveScript;

import java.util.HashMap;
import java.util.Map;

public class BodyIdentifierExpressionHandler {

  public static final String[] IMPLICIT_INPUTS = {"operationId", "method", "path", "partName"};
  private static final DataWeaveScript DEFAULT_SCRIPT =
      ExpressionHandlerUtils.compileDataWeaveScript(BodyIdentifierExpressionHandler.class, "bodyIdentifier.dwl",
                                                    IMPLICIT_INPUTS);
  private final DataWeaveScript script;

  /**
   * @param script parameterized by the user, which might have the extra '#['/']' we need to remove
   * @throws CompilationException if the user consumes bindings that are not present, see {@link #IMPLICIT_INPUTS}
   */
  public BodyIdentifierExpressionHandler(String script) throws CompilationException {
    this.script = ExpressionHandlerUtils.compileDataWeaveScript(script, IMPLICIT_INPUTS);
  }

  public BodyIdentifierExpressionHandler() {
    this.script = DEFAULT_SCRIPT;
  }

  public String evaluate(String operationId, String method, String path, String partName) {
    String contextInvoker = "bodyIdentifier";
    Map<String, String> map = new HashMap<>();
    map.put("operationId", operationId);
    map.put("method", method);
    map.put("path", path);
    map.put("partName", partName);
    String evaluate = ExpressionHandlerUtils.evaluate(script, map, contextInvoker);
    return evaluate;
  }
}
