/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType.STRING;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.HashCodeUtil.generateHashCode;
import static com.mulesoft.connectivity.rest.sdk.internal.webapi.util.XmlUtils.getXmlName;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.body.Field;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;

import java.util.List;

public class Parameter extends BaseParameter {

  private final String defaultValue;
  private final String parameterIdentifier;
  private final boolean isPassword;
  private final ResolverExpression<ValueProviderDefinition> valueProvider;
  private final List<Field> fields;
  private final String muleMetadataKeyId;
  private final String muleTypeResolver;

  public Parameter(String displayName,
                   String externalName,
                   String parameterIdentifier,
                   ParameterType parameterType,
                   TypeDefinition typeDefinition,
                   String muleAlias,
                   String description,
                   boolean required,
                   String defaultValue,
                   boolean password,
                   ResolverExpression<ValueProviderDefinition> valueProvider,
                   String muleMetadataKeyId,
                   String muleTypeResolver,
                   List<Field> fields) {

    this(
         parameterIdentifier, getXmlName(parameterIdentifier),
         displayName,
         externalName,
         parameterType,
         typeDefinition,
         muleAlias,
         description,
         required,
         defaultValue,
         password,
         valueProvider,
         muleMetadataKeyId,
         muleTypeResolver,
         fields);
  }

  protected Parameter(String parameterIdentifier,
                      String internalName,
                      String displayName,
                      String externalName,
                      ParameterType parameterType,
                      TypeDefinition typeDefinition,
                      String muleAlias,
                      String description,
                      boolean required,
                      String defaultValue,
                      boolean password,
                      ResolverExpression<ValueProviderDefinition> valueProvider,
                      String muleMetadataKeyId,
                      String muleTypeResolver,
                      List<Field> fields) {
    super(externalName, internalName, displayName, STRING, typeDefinition, muleAlias, description, required, parameterType);
    this.parameterIdentifier = parameterIdentifier;
    this.isPassword = password;
    this.defaultValue = defaultValue;
    this.valueProvider = valueProvider;
    this.muleMetadataKeyId = muleMetadataKeyId;
    this.muleTypeResolver = muleTypeResolver;
    this.fields = fields;
  }

  public String getDefaultValue() {
    return defaultValue;
  }

  public boolean isPassword() {
    return isPassword;
  }

  public String getParameterIdentifier() {
    return parameterIdentifier;
  }

  public ResolverExpression<ValueProviderDefinition> getValueProvider() {
    return valueProvider;
  }

  public String getMuleMetadataKeyId() {
    return muleMetadataKeyId;
  }

  public String getMuleTypeResolver() {
    return muleTypeResolver;
  }

  public List<Field> getFields() {
    return fields;
  }

  @Override
  public int hashCode() {
    return generateHashCode(internalName, displayName, description, required, defaultValue, typeDefinition,
                            isPassword);
  }

}
