/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.ConnectorSecurityScheme.SecuritySchemeType.CUSTOM_AUTHENTICATION;
import static java.util.Optional.ofNullable;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;

import java.util.List;
import java.util.Optional;

public class CustomAuthenticationScheme extends ConnectorSecurityScheme {

  private String fqn;

  public CustomAuthenticationScheme(String name, List<Parameter> queryParameters, List<Parameter> headers, String fqn) {
    super(CUSTOM_AUTHENTICATION, name, null, null);
    this.queryParameters.addAll(queryParameters);
    this.headers.addAll(headers);
    this.fqn = fqn;
  }

  public Optional<String> getFqn() {
    return ofNullable(fqn);
  }

}
