/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TypeDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.TriggerParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;

public class TriggerParameterBuilder {
    private final String name;
    private String displayName;
    private ParameterDataType dataType;
    private TypeDefinitionBuilder typeDefinitionBuilder = new TypeDefinitionBuilder();
    private String description;
    private String muleAlias;
    private Boolean required;

    public TriggerParameterBuilder(String name) {
        Objects.requireNonNull(name);
        this.name = name;
    }

    public TriggerParameterBuilder(TriggerParameterBuilder baseTriggerParameterBuilder) {
        this.name = baseTriggerParameterBuilder.name;
        this.displayName = baseTriggerParameterBuilder.displayName;
        this.dataType = baseTriggerParameterBuilder.dataType;
        this.typeDefinitionBuilder = baseTriggerParameterBuilder.typeDefinitionBuilder;
        this.description = baseTriggerParameterBuilder.description;
        this.required = baseTriggerParameterBuilder.required;
        this.muleAlias = baseTriggerParameterBuilder.muleAlias;
    }

    public String getName() {
        return this.name;
    }

    public TriggerParameterBuilder displayName(String displayName) {
        this.displayName = (String)ObjectUtils.defaultIfNull((Object)displayName, (Object)this.displayName);
        return this;
    }

    public TriggerParameterBuilder dataType(ParameterDataType dataType) {
        this.dataType = (ParameterDataType)((Object)ObjectUtils.defaultIfNull((Object)((Object)dataType), (Object)((Object)this.dataType)));
        return this;
    }

    public TriggerParameterBuilder description(String description) {
        this.description = (String)ObjectUtils.defaultIfNull((Object)description, (Object)this.description);
        return this;
    }

    public TriggerParameterBuilder muleAlias(String muleAlias) {
        this.muleAlias = (String)ObjectUtils.defaultIfNull((Object)muleAlias, (Object)this.muleAlias);
        return this;
    }

    public TriggerParameterBuilder required(Boolean required) {
        this.required = (Boolean)ObjectUtils.defaultIfNull((Object)required, (Object)this.required);
        return this;
    }

    public TypeDefinitionBuilder getTypeDefinitionBuilder() {
        return this.typeDefinitionBuilder;
    }

    public TriggerParameter build() {
        return new TriggerParameter(this.name, this.displayName, this.dataType, null, this.muleAlias, this.description, this.required);
    }

    public TriggerParameter build(TypeSchemaPool typeSchemaPool) {
        TypeDefinition typeDefinition = null;
        if (this.dataType == null) {
            typeDefinition = this.getTypeDefinitionBuilder().build(typeSchemaPool, null);
        }
        TriggerParameter triggerParameter = new TriggerParameter(this.name, this.displayName, this.dataType, typeDefinition, this.muleAlias, this.description, this.required);
        return triggerParameter;
    }
}

