/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.sampledata;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.ConnectorOperation;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.ResolverDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestBinding;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.script.DwScriptDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.script.ScriptDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.expression.DataWeaveExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.Argument;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.BaseParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.sampledata.SampleDataDefinition;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.trigger.Trigger;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;

public class SampleDataDefinitionBuilder
extends ResolverDefinitionBuilder<SampleDataDefinition> {
    private HttpRequestDataExpression httpRequestDataExpression;
    private ScriptDataExpression scriptDataExpression;

    public SampleDataDefinitionBuilder httpRequestDataExpression(HttpRequestDataExpression httpRequestDataExpression) {
        this.httpRequestDataExpression = (HttpRequestDataExpression)ObjectUtils.defaultIfNull((Object)httpRequestDataExpression, (Object)this.httpRequestDataExpression);
        return this;
    }

    public SampleDataDefinitionBuilder scriptDataExpression(ScriptDataExpression scriptDataExpression) {
        this.scriptDataExpression = (ScriptDataExpression)ObjectUtils.defaultIfNull((Object)scriptDataExpression, (Object)this.scriptDataExpression);
        return this;
    }

    @Override
    public SampleDataDefinition build() {
        Objects.requireNonNull(this.httpRequestDataExpression);
        return new SampleDataDefinition(this.httpRequestDataExpression, this.scriptDataExpression);
    }

    public SampleDataDefinition buildSameOperation(ConnectorOperation operation) {
        Objects.requireNonNull(operation);
        return this.buildSampleDataSameOperationDefinition(operation);
    }

    public SampleDataDefinition buildSameOperation(Trigger trigger) {
        Objects.requireNonNull(trigger);
        return this.buildSampleDataSameOperationDefinition(trigger);
    }

    private SampleDataDefinition buildSampleDataSameOperationDefinition(ConnectorOperation connectorOperation) {
        DwScriptDataExpression paginationExpression = null;
        if (connectorOperation.hasPagination()) {
            paginationExpression = new DwScriptDataExpression(connectorOperation.getPagination().getPaginationResponseExpression());
        }
        return new SampleDataDefinition(new HttpRequestDataExpression(connectorOperation.getPath(), connectorOperation.getHttpMethod(), this.buildBindings(connectorOperation)), paginationExpression);
    }

    private SampleDataDefinition buildSampleDataSameOperationDefinition(Trigger trigger) {
        return new SampleDataDefinition(new HttpRequestDataExpression(trigger.getOperation().getPath(), trigger.getOperation().getHttpMethod(), this.buildTriggerBindings(trigger)), new DwScriptDataExpression(this.getExpressionForFirstItem(trigger.getItemsExpression())));
    }

    private String getExpressionForFirstItem(String expression) {
        if (expression.startsWith("#[") && expression.endsWith("]")) {
            expression = expression.substring(2, expression.length() - 1);
        }
        return "(" + expression + ")[0]";
    }

    private HttpRequestBinding buildTriggerBindings(Trigger trigger) {
        if (trigger.getParameterBindings() == null || trigger.getParameterBindings().isEmpty()) {
            return null;
        }
        return new HttpRequestBinding(this.buildTriggerArguments(trigger, ParameterType.URI), this.buildTriggerArguments(trigger, ParameterType.QUERY), this.buildTriggerArguments(trigger, ParameterType.HEADER));
    }

    private List<Argument> buildTriggerArguments(Trigger trigger, ParameterType parameterType) {
        return trigger.getParameterBindings().stream().filter(x -> x.getParameterType().equals((Object)parameterType)).map(x -> this.buildArgument(x.getName(), x.getExpression())).collect(Collectors.toList());
    }

    private HttpRequestBinding buildBindings(ConnectorOperation connectorOperation) {
        List<Parameter> requiredUriParams = this.getRequiredParameters(connectorOperation.getUriParameters());
        List<Parameter> requiredQueryParams = this.getRequiredParameters(connectorOperation.getQueryParameters());
        List<Parameter> requiredHeaders = this.getRequiredParameters(connectorOperation.getHeaders());
        if (requiredUriParams.isEmpty() && requiredQueryParams.isEmpty() && requiredHeaders.isEmpty()) {
            return null;
        }
        return new HttpRequestBinding(this.buildArguments(requiredUriParams, ParameterType.URI), this.buildArguments(requiredQueryParams, ParameterType.QUERY), this.buildArguments(requiredHeaders, ParameterType.HEADER));
    }

    private List<Parameter> getRequiredParameters(List<Parameter> parameterList) {
        return parameterList.stream().filter(BaseParameter::isRequired).collect(Collectors.toList());
    }

    private List<Argument> buildArguments(List<Parameter> parameters, ParameterType parameterType) {
        return parameters.stream().map(x -> this.buildArgument(x.getExternalName(), parameterType)).collect(Collectors.toList());
    }

    private Argument buildArgument(String externalName, ParameterType parameterType) {
        return this.buildArgument(externalName, String.format("%s.%s", parameterType.getBinding(), externalName));
    }

    private Argument buildArgument(String externalName, String expression) {
        return new Argument(externalName, new DataWeaveExpression(expression));
    }
}

