/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.Parameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.security.TestConnectionConfig;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.util.HashCodeUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class ConnectorSecurityScheme {
    protected final List<Parameter> headers = new ArrayList<Parameter>();
    protected final List<Parameter> queryParameters = new ArrayList<Parameter>();
    protected final SecuritySchemeType schemeType;
    protected final String name;
    protected final String alias;
    protected final TestConnectionConfig testConnectionConfig;

    public ConnectorSecurityScheme(SecuritySchemeType schemeType, String name, String alias, TestConnectionConfig testConnectionConfig) {
        this.schemeType = schemeType;
        this.name = name;
        this.alias = alias;
        this.testConnectionConfig = testConnectionConfig;
    }

    public SecuritySchemeType getSchemeType() {
        return this.schemeType;
    }

    public String getName() {
        if (this.schemeType.equals((Object)SecuritySchemeType.UNSECURED)) {
            return SecuritySchemeType.UNSECURED.name();
        }
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public TestConnectionConfig getTestConnectionConfig() {
        return this.testConnectionConfig;
    }

    public List<Parameter> getQueryParameters() {
        return this.queryParameters;
    }

    public List<Parameter> getHeaders() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectorSecurityScheme)) {
            return false;
        }
        ConnectorSecurityScheme that = (ConnectorSecurityScheme)o;
        return that.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return HashCodeUtil.generateHashCode(new Object[]{this.schemeType, this.headers, this.queryParameters});
    }

    public static enum SecuritySchemeType {
        BASIC("Basic Authentication"),
        OAUTH1("OAuth 1.0"),
        OAUTH2("OAuth 2.0"),
        PASS_THROUGH("Pass Through"),
        DIGEST_AUTHENTICATION("Digest Authentication"),
        CUSTOM_AUTHENTICATION("Custom Authentication"),
        BEARER("Bearer Authentication"),
        UNSECURED("Unsecured"),
        NOT_SUPPORTED("Not Supported");

        private final String type;

        private SecuritySchemeType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

