/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.TypeSchemaPool;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.valueprovider.ValueProviderBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.generic.ParameterDataType;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.TriggerParameter;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.type.TypeDefinition;

import static java.util.Objects.requireNonNull;
import static org.apache.commons.lang3.ObjectUtils.defaultIfNull;

public class TriggerParameterBuilder {

  private final String name;
  private String displayName;
  private ParameterDataType dataType;
  private TypeDefinitionBuilder typeDefinitionBuilder = new TypeDefinitionBuilder();
  private String description;
  private String muleAlias;
  private Boolean required;
  private String muleMetadataKeyId;
  private String muleTypeResolver;
  private final ValueProviderBuilder valueProviderExpressionBuilder = new ValueProviderBuilder();

  public TriggerParameterBuilder(String name) {
    requireNonNull(name);
    this.name = name;
  }

  public TriggerParameterBuilder(TriggerParameterBuilder baseTriggerParameterBuilder) {
    this.name = baseTriggerParameterBuilder.name;
    this.displayName = baseTriggerParameterBuilder.displayName;
    this.dataType = baseTriggerParameterBuilder.dataType;
    this.typeDefinitionBuilder = baseTriggerParameterBuilder.typeDefinitionBuilder;
    this.description = baseTriggerParameterBuilder.description;
    this.required = baseTriggerParameterBuilder.required;
    this.muleAlias = baseTriggerParameterBuilder.muleAlias;
    this.muleMetadataKeyId = baseTriggerParameterBuilder.muleMetadataKeyId;
    this.muleTypeResolver = baseTriggerParameterBuilder.muleTypeResolver;
  }

  public String getName() {
    return name;
  }

  public ValueProviderBuilder getValueProviderExpressionBuilder() {
    return valueProviderExpressionBuilder;
  }

  public TriggerParameterBuilder displayName(String displayName) {
    this.displayName = defaultIfNull(displayName, this.displayName);
    return this;
  }

  public TriggerParameterBuilder dataType(ParameterDataType dataType) {
    this.dataType = defaultIfNull(dataType, this.dataType);
    return this;
  }

  public TriggerParameterBuilder description(String description) {
    this.description = defaultIfNull(description, this.description);
    return this;
  }

  public TriggerParameterBuilder muleAlias(String muleAlias) {
    this.muleAlias = defaultIfNull(muleAlias, this.muleAlias);
    return this;
  }

  public TriggerParameterBuilder required(Boolean required) {
    this.required = defaultIfNull(required, this.required);
    return this;
  }

  public TriggerParameterBuilder muleMetadataKeyId(String muleMetadataKeyId) {
    this.muleMetadataKeyId = defaultIfNull(muleMetadataKeyId, this.muleMetadataKeyId);
    return this;
  }

  public TriggerParameterBuilder muleTypeResolver(String muleTypeResolver) {
    this.muleTypeResolver = defaultIfNull(muleTypeResolver, this.muleTypeResolver);
    return this;
  }

  public TypeDefinitionBuilder getTypeDefinitionBuilder() {
    return this.typeDefinitionBuilder;
  }

  public TriggerParameter build(TypeSchemaPool typeSchemaPool) {
    TypeDefinition typeDefinition = null;
    if (dataType == null) {
      typeDefinition = getTypeDefinitionBuilder().build(typeSchemaPool, null);
    }
    final TriggerParameter triggerParameter =
        new TriggerParameter(name, displayName, dataType, typeDefinition, muleAlias, description, required, muleMetadataKeyId,
                             muleTypeResolver, valueProviderExpressionBuilder.build());
    return triggerParameter;
  }
}
