/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.valueprovider;

import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.valueprovider.ValueProviderBuilder.ValueProviderType.INLINE;
import static com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.valueprovider.ValueProviderBuilder.ValueProviderType.REFERENCE;
import static org.apache.commons.lang3.ObjectUtils.defaultIfNull;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.ResolverDeclarationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.ResolverDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.ResolverReferenceBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;

public class ValueProviderBuilder {

  protected enum ValueProviderType {
    INLINE, REFERENCE;
  }

  private ValueProviderType type;
  private ValueProviderDefinitionBuilder definitionBuilder;
  private ValueProviderReferenceBuilder referenceBuilder;

  public ValueProviderDefinitionBuilder inline() {
    this.type = INLINE;
    this.definitionBuilder = new ValueProviderDefinitionBuilder();
    return definitionBuilder;
  }

  public ValueProviderReferenceBuilder reference(String declarationName) {
    this.type = REFERENCE;

    this.referenceBuilder =
        new ValueProviderReferenceBuilder(
                                          new ValueProviderDeclarationBuilder(
                                                                              declarationName,
                                                                              new ValueProviderDefinitionBuilder()));

    return referenceBuilder;
  }

  public ResolverExpression<ValueProviderDefinition> build() {
    if (type == null) {
      return null;
    }

    if (type.equals(INLINE)) {
      return definitionBuilder.build();
    }

    if (type.equals(REFERENCE)) {
      return referenceBuilder.build();
    }

    throw new IllegalArgumentException("Builder type not supported. This is a bug.");
  }

  public static class ValueProviderDefinitionBuilder extends ResolverDefinitionBuilder<ValueProviderDefinition> {

    private HttpRequestDataExpression request;
    private String script;
    private String itemExtractionExpression;
    private String itemValueExpression;
    private String itemDisplayNameExpression;
    private String fqn;

    public ValueProviderDefinitionBuilder request(HttpRequestDataExpression request) {
      this.request = request;
      return this;
    }

    public ValueProviderDefinitionBuilder script(String script) {
      this.script = script;
      return this;
    }

    public ValueProviderDefinitionBuilder itemExtractionExpression(String itemExtractionExpression) {
      this.itemExtractionExpression = defaultIfNull(itemExtractionExpression, this.itemExtractionExpression);
      return this;
    }

    public ValueProviderDefinitionBuilder itemValueExpression(String itemValueExpression) {
      this.itemValueExpression = defaultIfNull(itemValueExpression, this.itemValueExpression);
      return this;
    }

    public ValueProviderDefinitionBuilder itemDisplayNameExpression(String itemDisplayNameExpression) {
      this.itemDisplayNameExpression = defaultIfNull(itemDisplayNameExpression, this.itemDisplayNameExpression);
      return this;
    }

    public ValueProviderDefinitionBuilder fqn(String fqn) {
      this.fqn = defaultIfNull(fqn, this.fqn);
      return this;
    }

    @Override
    protected ValueProviderDefinition build() {
      return new ValueProviderDefinition(request, script, itemExtractionExpression, itemValueExpression,
                                         itemDisplayNameExpression, fqn);
    }
  }

  public static class ValueProviderDeclarationBuilder
      extends ResolverDeclarationBuilder<ValueProviderDefinitionBuilder, ValueProviderDefinition> {

    protected ValueProviderDeclarationBuilder(String name, ValueProviderDefinitionBuilder resolverDefinitionBuilder) {
      super(name, resolverDefinitionBuilder);
    }
  }

  public static class ValueProviderReferenceBuilder extends
      ResolverReferenceBuilder<ValueProviderDeclarationBuilder, ValueProviderDefinitionBuilder, ValueProviderDefinition> {

    protected ValueProviderReferenceBuilder(ValueProviderDeclarationBuilder declarationBuilder) {
      super(declarationBuilder);
    }
  }
}
