/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.InterceptorBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.InterceptorOutput;

public class DescriptorInterceptorLoader {


  static void loadInterceptors(ConnectorDescriptor connectorDescriptor, ConnectorModelBuilder connectorBuilder) {

    if (connectorDescriptor.getInterceptorDescriptor() == null) {
      return;
    }

    // On error
    if (connectorDescriptor.getInterceptorDescriptor().getInterceptorOnError() != null) {
      connectorDescriptor.getInterceptorDescriptor().getInterceptorOnError().getConditions().stream()
          .forEach(interceptorDescriptor -> loadInterceptor(interceptorDescriptor.getInterceptorOutput(),
                                                            interceptorDescriptor.getExpression(),
                                                            connectorBuilder.createInterceptor(), true));
    }

    // Default on error
    if (connectorDescriptor.getInterceptorDescriptor().getInterceptorOnError() != null &&
        connectorDescriptor.getInterceptorDescriptor().getInterceptorOnError().getDefaultCondition() != null) {
      loadInterceptor(connectorDescriptor.getInterceptorDescriptor().getInterceptorOnError().getDefaultCondition(),
                      "#[true]",
                      connectorBuilder.createInterceptor(), true);
    }

    // On success
    if (connectorDescriptor.getInterceptorDescriptor().getInterceptorOnSuccess() != null) {
      connectorDescriptor.getInterceptorDescriptor().getInterceptorOnSuccess().getConditions().stream()
          .forEach(interceptorDescriptor -> loadInterceptor(interceptorDescriptor.getInterceptorOutput(),
                                                            interceptorDescriptor.getExpression(),
                                                            connectorBuilder.createInterceptor(), false));
    }

  }

  private static void loadInterceptor(InterceptorOutput interceptorOutput, String condition,
                                      InterceptorBuilder interceptorBuilder, boolean isOnError) {

    interceptorBuilder
        .expression(condition)
        .statusCode(interceptorOutput.getStatusCode())
        .reasonPhrase(interceptorOutput.getReasonPhrase())
        .headers(interceptorOutput.getHeaders())
        .body(interceptorOutput.getBody())
        .isOnError(isOnError);
  }

}
