/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.SecurityDefaultParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.BasicAuthDefaultParameters;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.BearerAuthDefaultParameters;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.DigestAuthDefaultParameters;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.SecurityDefaultParameters;
import org.apache.commons.lang3.ObjectUtils;

public class SecurityDefaultParametersBuilder {
    private SecurityDefaultParametersBuilder builder;

    public BasicAuthBuilder basic() {
        this.builder = new BasicAuthBuilder();
        return (BasicAuthBuilder)this.builder;
    }

    public BearerAuthBuilder bearer() {
        this.builder = new BearerAuthBuilder();
        return (BearerAuthBuilder)this.builder;
    }

    public DigestAuthBuilder digest() {
        this.builder = new DigestAuthBuilder();
        return (DigestAuthBuilder)this.builder;
    }

    protected SecurityDefaultParameters build() {
        if (this.builder == null) {
            return null;
        }
        return this.builder.build();
    }

    public static class DigestAuthBuilder
    extends SecurityDefaultParametersBuilder {
        private SecurityDefaultParameterBuilder username;
        private SecurityDefaultParameterBuilder password;

        public DigestAuthBuilder username(SecurityDefaultParameterBuilder username) {
            this.username = (SecurityDefaultParameterBuilder)ObjectUtils.defaultIfNull((Object)username, (Object)this.username);
            return this;
        }

        public DigestAuthBuilder password(SecurityDefaultParameterBuilder password) {
            this.password = (SecurityDefaultParameterBuilder)ObjectUtils.defaultIfNull((Object)password, (Object)this.password);
            return this;
        }

        @Override
        public DigestAuthDefaultParameters build() {
            return new DigestAuthDefaultParameters(this.username.build(), this.password.build());
        }
    }

    public static class BearerAuthBuilder
    extends SecurityDefaultParametersBuilder {
        private SecurityDefaultParameterBuilder token;

        public BearerAuthBuilder token(SecurityDefaultParameterBuilder token) {
            this.token = (SecurityDefaultParameterBuilder)ObjectUtils.defaultIfNull((Object)token, (Object)this.token);
            return this;
        }

        @Override
        public BearerAuthDefaultParameters build() {
            return new BearerAuthDefaultParameters(this.token.build());
        }
    }

    public static class BasicAuthBuilder
    extends SecurityDefaultParametersBuilder {
        private SecurityDefaultParameterBuilder username;
        private SecurityDefaultParameterBuilder password;

        public BasicAuthBuilder username(SecurityDefaultParameterBuilder username) {
            this.username = (SecurityDefaultParameterBuilder)ObjectUtils.defaultIfNull((Object)username, (Object)this.username);
            return this;
        }

        public BasicAuthBuilder password(SecurityDefaultParameterBuilder password) {
            this.password = (SecurityDefaultParameterBuilder)ObjectUtils.defaultIfNull((Object)password, (Object)this.password);
            return this;
        }

        @Override
        public BasicAuthDefaultParameters build() {
            return new BasicAuthDefaultParameters(this.username.build(), this.password.build());
        }
    }
}

