/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.valueprovider;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.ResolverDeclarationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.ResolverDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.resolver.ResolverReferenceBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.dataexpression.httprequest.HttpRequestDataExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.resolver.ResolverExpression;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.valueprovider.ValueProviderDefinition;
import org.apache.commons.lang3.ObjectUtils;

public class ValueProviderBuilder {
    private ValueProviderType type;
    private ValueProviderDefinitionBuilder definitionBuilder;
    private ValueProviderReferenceBuilder referenceBuilder;

    public ValueProviderDefinitionBuilder inline() {
        this.type = ValueProviderType.INLINE;
        this.definitionBuilder = new ValueProviderDefinitionBuilder();
        return this.definitionBuilder;
    }

    public ValueProviderReferenceBuilder reference(String declarationName) {
        this.type = ValueProviderType.REFERENCE;
        this.referenceBuilder = new ValueProviderReferenceBuilder(new ValueProviderDeclarationBuilder(declarationName, new ValueProviderDefinitionBuilder()));
        return this.referenceBuilder;
    }

    public ResolverExpression<ValueProviderDefinition> build() {
        if (this.type == null) {
            return null;
        }
        if (this.type.equals((Object)ValueProviderType.INLINE)) {
            return this.definitionBuilder.build();
        }
        if (this.type.equals((Object)ValueProviderType.REFERENCE)) {
            return this.referenceBuilder.build();
        }
        throw new IllegalArgumentException("Builder type not supported. This is a bug.");
    }

    public static class ValueProviderReferenceBuilder
    extends ResolverReferenceBuilder<ValueProviderDeclarationBuilder, ValueProviderDefinitionBuilder, ValueProviderDefinition> {
        protected ValueProviderReferenceBuilder(ValueProviderDeclarationBuilder declarationBuilder) {
            super(declarationBuilder);
        }
    }

    public static class ValueProviderDeclarationBuilder
    extends ResolverDeclarationBuilder<ValueProviderDefinitionBuilder, ValueProviderDefinition> {
        protected ValueProviderDeclarationBuilder(String name, ValueProviderDefinitionBuilder resolverDefinitionBuilder) {
            super(name, resolverDefinitionBuilder);
        }
    }

    public static class ValueProviderDefinitionBuilder
    extends ResolverDefinitionBuilder<ValueProviderDefinition> {
        private HttpRequestDataExpression request;
        private String script;
        private String itemExtractionExpression;
        private String itemValueExpression;
        private String itemDisplayNameExpression;
        private String fqn;

        public ValueProviderDefinitionBuilder request(HttpRequestDataExpression request) {
            this.request = request;
            return this;
        }

        public ValueProviderDefinitionBuilder script(String script) {
            this.script = script;
            return this;
        }

        public ValueProviderDefinitionBuilder itemExtractionExpression(String itemExtractionExpression) {
            this.itemExtractionExpression = (String)ObjectUtils.defaultIfNull((Object)itemExtractionExpression, (Object)this.itemExtractionExpression);
            return this;
        }

        public ValueProviderDefinitionBuilder itemValueExpression(String itemValueExpression) {
            this.itemValueExpression = (String)ObjectUtils.defaultIfNull((Object)itemValueExpression, (Object)this.itemValueExpression);
            return this;
        }

        public ValueProviderDefinitionBuilder itemDisplayNameExpression(String itemDisplayNameExpression) {
            this.itemDisplayNameExpression = (String)ObjectUtils.defaultIfNull((Object)itemDisplayNameExpression, (Object)this.itemDisplayNameExpression);
            return this;
        }

        public ValueProviderDefinitionBuilder fqn(String fqn) {
            this.fqn = (String)ObjectUtils.defaultIfNull((Object)fqn, (Object)this.fqn);
            return this;
        }

        @Override
        protected ValueProviderDefinition build() {
            return new ValueProviderDefinition(this.request, this.script, this.itemExtractionExpression, this.itemValueExpression, this.itemDisplayNameExpression, this.fqn);
        }
    }

    protected static enum ValueProviderType {
        INLINE,
        REFERENCE;

    }
}

