/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor;

import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.QueryParamArrayFormat;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ConnectorModelBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.FieldBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.OperationBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.ParameterBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.builder.TypeDefinitionBuilder;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorParameterLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorSampleDataLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorTypeLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.loader.descriptor.DescriptorValueProviderLoader;
import com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter.ParameterType;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.BodyDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.ConnectorDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.EndPointDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.FieldDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.OperationDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.PartDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.RequestDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.resolvers.ResolverExpressionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.sampledata.SampleDataDefinitionDescriptor;
import com.mulesoft.connectivity.rest.sdk.internal.descriptor.model.valueprovider.ValueProviderDefinitionDescriptor;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DescriptorOperationLoader {
    static void loadOperations(ConnectorDescriptor descriptor, ConnectorModelBuilder connectorModelBuilder) {
        for (EndPointDescriptor endPointDescriptor : descriptor.getEndpoints()) {
            DescriptorOperationLoader.loadEndpoint(endPointDescriptor, connectorModelBuilder);
            for (OperationDescriptor operationDescriptor : endPointDescriptor.getOperations()) {
                OperationBuilder operationBuilder = connectorModelBuilder.getOrCreateOperationBuilder(null, endPointDescriptor.getPath(), operationDescriptor.getMethod(), null);
                DescriptorOperationLoader.loadOperation(descriptor, endPointDescriptor, operationDescriptor, operationBuilder);
            }
        }
    }

    private static void loadEndpoint(EndPointDescriptor endPointDescriptor, ConnectorModelBuilder connectorModelBuilder) {
        for (OperationBuilder operationBuilder : connectorModelBuilder.getOperationBuildersByPath(endPointDescriptor.getPath())) {
            operationBuilder.ignored(endPointDescriptor.isIgnored());
            operationBuilder.alternativeBaseUri(endPointDescriptor.getBaseUri());
        }
    }

    private static void loadOperation(ConnectorDescriptor connectorDescriptor, EndPointDescriptor endPointDescriptor, OperationDescriptor operationDescriptor, OperationBuilder operationBuilder) {
        operationBuilder.displayName(operationDescriptor.getDisplayName()).description(operationDescriptor.getDescription()).alias(operationDescriptor.getAlias()).alternativeBaseUri(DescriptorOperationLoader.loadAlternativeBaseUri(endPointDescriptor, operationDescriptor)).pagination(operationDescriptor.getPagination()).skipOutputTypeValidation(operationDescriptor.getSkipOutputTypeValidation()).voidOperation(operationDescriptor.getVoidOperation()).queryParamArrayFormat(DescriptorOperationLoader.loadOperationQueryParamArrayFormat(connectorDescriptor, operationDescriptor)).ignored(DescriptorOperationLoader.loadIgnoredOperation(endPointDescriptor, operationDescriptor)).privateOperation(operationDescriptor.getPrivateOperation()).descriptorIdentifier(operationDescriptor.getOperationIdentifier()).refined(operationDescriptor.getRefined());
        DescriptorOperationLoader.loadOperationInputType(operationDescriptor, operationBuilder);
        DescriptorOperationLoader.loadOperationOutputType(operationDescriptor, operationBuilder);
        if (operationDescriptor.getExpects() != null) {
            DescriptorParameterLoader.loadParameters(operationDescriptor.getExpects().getUriParameter(), ParameterType.URI, operationBuilder);
            DescriptorParameterLoader.loadParameters(operationDescriptor.getExpects().getQueryParameter(), ParameterType.QUERY, operationBuilder);
            DescriptorParameterLoader.loadParameters(operationDescriptor.getExpects().getHeader(), ParameterType.HEADER, operationBuilder);
            DescriptorOperationLoader.loadBody(operationDescriptor.getExpects().getBody(), operationBuilder);
        }
        DescriptorSampleDataLoader.loadSampleData((ResolverExpressionDescriptor<SampleDataDefinitionDescriptor>)operationDescriptor.getSampleDataExpressionDescriptor(), operationBuilder.getSampleDataBuilder());
    }

    private static void loadBody(BodyDescriptor body, OperationBuilder operationBuilder) {
        if (body == null) {
            return;
        }
        operationBuilder.getBodyBuilder().bodyIdentifier(body.getBodyIdentifier());
        for (FieldDescriptor fieldDescriptor : body.getFieldDescriptors()) {
            FieldBuilder fieldBuilder = new FieldBuilder(fieldDescriptor.getParamName());
            DescriptorValueProviderLoader.loadValueProvider((ResolverExpressionDescriptor<ValueProviderDefinitionDescriptor>)fieldDescriptor.getValueProviders(), fieldBuilder.getValueProviderBuilder());
            operationBuilder.getBodyBuilder().getFieldBuilders().add(fieldBuilder);
        }
    }

    static void loadOperationInputType(OperationDescriptor operationDescriptor, OperationBuilder operationBuilder) {
        if (StringUtils.isNotBlank((CharSequence)operationDescriptor.getInputMediaType())) {
            operationBuilder.setDefaultInputMediaType(DescriptorTypeLoader.loadMediaType(operationDescriptor.getInputMediaType()));
        }
        if (StringUtils.isNotBlank((CharSequence)operationDescriptor.getInputTypeSchema())) {
            operationBuilder.forceInputTypeSchema(operationDescriptor.getInputTypeSchema());
        }
        DescriptorOperationLoader.loadParts(operationDescriptor.getExpects(), operationBuilder);
    }

    private static void loadParts(RequestDescriptor expects, OperationBuilder operationBuilder) {
        if (expects == null) {
            return;
        }
        for (TypeDefinitionBuilder builder : operationBuilder.getMultipartInputMetadataBuilders()) {
            for (PartDescriptor partDescriptor : expects.getPart()) {
                ParameterBuilder partParameter = builder.getPartParameter(partDescriptor.getPartName());
                partParameter.parameterIdentifier(partDescriptor.getPartIdentifier()).displayName(partDescriptor.getDisplayName()).description(partDescriptor.getDescription()).filePart(partDescriptor.isFilePart());
                TypeDefinitionBuilder typeDefinitionBuilder = partParameter.getTypeDefinitionBuilder();
                if (StringUtils.isNotBlank((CharSequence)partDescriptor.getInputType())) {
                    typeDefinitionBuilder.object().typeSchema(() -> ((PartDescriptor)partDescriptor).getInputType());
                }
                typeDefinitionBuilder.mediaType(DescriptorTypeLoader.loadMediaType(partDescriptor.getContentType()));
            }
        }
    }

    static void loadOperationOutputType(OperationDescriptor operationDescriptor, OperationBuilder operationBuilder) {
        if (StringUtils.isNotBlank((CharSequence)operationDescriptor.getOutputMediaType())) {
            operationBuilder.setDefaultOutputMediaType(DescriptorTypeLoader.loadMediaType(operationDescriptor.getOutputMediaType()));
        }
        if (StringUtils.isNotBlank((CharSequence)operationDescriptor.getOutputTypeSchema())) {
            operationBuilder.forceOutputTypeSchema(operationDescriptor.getOutputTypeSchema());
        }
    }

    private static Boolean loadIgnoredOperation(EndPointDescriptor endPointDescriptor, OperationDescriptor operationDescriptor) {
        return (Boolean)ObjectUtils.defaultIfNull((Object)operationDescriptor.isIgnored(), (Object)endPointDescriptor.isIgnored());
    }

    private static QueryParamArrayFormat loadOperationQueryParamArrayFormat(ConnectorDescriptor connectorDescriptor, OperationDescriptor operationDescriptor) {
        if (StringUtils.isNotBlank((CharSequence)operationDescriptor.getQueryParamArrayFormat())) {
            return QueryParamArrayFormat.valueOf(operationDescriptor.getQueryParamArrayFormat().toUpperCase());
        }
        if (StringUtils.isNotBlank((CharSequence)connectorDescriptor.getQueryParamArrayFormat())) {
            return QueryParamArrayFormat.valueOf(connectorDescriptor.getQueryParamArrayFormat().toUpperCase());
        }
        return null;
    }

    private static String loadAlternativeBaseUri(EndPointDescriptor endPointDescriptor, OperationDescriptor operationDescriptor) {
        return StringUtils.isNotBlank((CharSequence)operationDescriptor.getBaseUri()) ? operationDescriptor.getBaseUri() : (StringUtils.isNotBlank((CharSequence)endPointDescriptor.getBaseUri()) ? endPointDescriptor.getBaseUri() : null);
    }
}

