/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel;

import static java.lang.String.format;

public enum HTTPMethod {

  GET, POST, PUT, PATCH, DELETE, OPTIONS, HEAD;

  private static final String ERROR_TEMPLATE = "Http method '%s' should be a get, post, put, patch, delete, options or head. "
      + "This is a bug.";

  public static HTTPMethod fromString(String method) {
    for (HTTPMethod httpMethod : HTTPMethod.values()) {
      if (method.equalsIgnoreCase(httpMethod.name())) {
        return httpMethod;
      }
    }

    throw new IllegalArgumentException(format(ERROR_TEMPLATE, method));
  }

}
