/*
 * (c) 2003-2021 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.connectivity.rest.sdk.internal.connectormodel.parameter;

import static org.apache.commons.lang3.ObjectUtils.defaultIfNull;

public class DigestAuthDefaultParameters extends SecurityDefaultParameters {

  private final SecurityDefaultParameter username;
  private final SecurityDefaultParameter password;

  public DigestAuthDefaultParameters(SecurityDefaultParameter username, SecurityDefaultParameter password) {
    this.username = defaultIfNull(username, empty());
    this.password = defaultIfNull(password, empty());
  }

  public SecurityDefaultParameter getUsername() {
    return username;
  }

  public SecurityDefaultParameter getPassword() {
    return password;
  }
}
